/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Instance;
import weka.core.Instances;

public class RBFKernel
extends CachedKernel {
    private double[] m_kernelPrecalc;
    private double m_gamma = 0.01;

    public RBFKernel(Instances instances, int n, double d) throws Exception {
        super(instances, n);
        this.m_gamma = d;
        this.m_kernelPrecalc = new double[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.m_kernelPrecalc[i] = this.dotProd(instances.instance(i), instances.instance(i));
        }
    }

    protected double evaluate(int n, int n2, Instance instance) throws Exception {
        double d = n == -1 ? this.dotProd(instance, instance) : this.m_kernelPrecalc[n];
        Instance instance2 = this.m_data.instance(n2);
        double d2 = Math.exp(this.m_gamma * (2.0 * this.dotProd(instance, instance2) - d - this.m_kernelPrecalc[n2]));
        return d2;
    }
}

