## ---- include = FALSE------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup-----------------------------------------------------------------
library(BUSpaRse)
library(TENxBUSData)

## --------------------------------------------------------------------------
# Specify other attributes
tr2g_mm <- tr2g_ensembl("Mus musculus", ensembl_version = 94, 
                        other_attrs = "description")

## --------------------------------------------------------------------------
head(tr2g_mm)

## --------------------------------------------------------------------------
# Plants
tr2g_at <- tr2g_ensembl("Arabidopsis thaliana", type = "plant")

## --------------------------------------------------------------------------
head(tr2g_at)

## --------------------------------------------------------------------------
# Subset of a real Ensembl FASTA file
toy_fasta <- system.file("testdata/fasta_test.fasta", package = "BUSpaRse")
tr2g_fa <- tr2g_fasta(file = toy_fasta)
head(tr2g_fa)

## --------------------------------------------------------------------------
# Subset of a reral GTF file from Ensembl
toy_gtf <- system.file("testdata/gtf_test.gtf", package = "BUSpaRse")
tr2g_tg <- tr2g_gtf(toy_gtf)
head(tr2g_tg)

## --------------------------------------------------------------------------
# Download kallisto bus example output
TENxBUSData(".", dataset = "retina")
tr2g_mm <- sort_tr2g(tr2g_mm, kallisto_out_path = "./out_retina")

## --------------------------------------------------------------------------
# Download example mixed species output
TENxBUSData(".", dataset = "hgmm100")
tr2g_hgmm <- transcript2gene(species = c("Homo sapiens", "Mus musculus"),
                             type = "vertebrate",
                             ensembl_version = 94,
                             kallisto_out_path = "./out_hgmm100")

## --------------------------------------------------------------------------
save_tr2g_bustools(tr2g_at, file_save = "./tr2g_at.tsv")

## --------------------------------------------------------------------------
sessionInfo()

