## ----, echo=FALSE--------------------------------------------------------
suppressPackageStartupMessages(library(VariantAnnotation))
suppressPackageStartupMessages(library(AnnotationHub))

## ------------------------------------------------------------------------
hub <- AnnotationHub()
vcf <- hub$dbSNP.organisms.human_9606.VCF.ByChromosome.22.12159.GIH.RData 
dim(vcf)

## ----, echo=FALSE--------------------------------------------------------
suppressPackageStartupMessages(library(TxDb.Hsapiens.UCSC.hg19.knownGene))

## ------------------------------------------------------------------------
txdb_hg19 <- TxDb.Hsapiens.UCSC.hg19.knownGene
head(seqlevels(txdb_hg19))
seqlevels(vcf)
seqlevels(vcf) <- paste0("chr", seqlevels(vcf))
unique(genome(txdb_hg19))
genome(vcf) <- "hg19"

## ------------------------------------------------------------------------
intersect(seqlevels(txdb_hg19), seqlevels(vcf))

## ------------------------------------------------------------------------
gr_hg19 <- rowData(vcf)

## ------------------------------------------------------------------------
library(TxDb.Mmusculus.UCSC.mm10.ensGene)
txdb_mm10 <- TxDb.Mmusculus.UCSC.mm10.ensGene

## ------------------------------------------------------------------------
head(seqlevels(txdb_mm10))
gr_mm10 <- GRanges("chr4", IRanges(c(4000000, 107889000), width=1000))

## ------------------------------------------------------------------------
unique(genome(txdb_mm10))
genome(gr_mm10) <- "mm10"

## ------------------------------------------------------------------------
loc_hg19 <- locateVariants(gr_hg19, txdb_hg19, AllVariants())
table(loc_hg19$LOCATION)
loc_mm10 <- locateVariants(gr_mm10, txdb_mm10, AllVariants()) 
table(loc_mm10$LOCATION)

## ----, echo=FALSE--------------------------------------------------------
suppressPackageStartupMessages(library(org.Hs.eg.db))

## ------------------------------------------------------------------------
cols <- c("UNIPROT", "PFAM")
keys <- unique(loc_hg19$GENEID)
head(select(org.Hs.eg.db, keys, cols, keytype="ENTREZID"))

## ----, echo=FALSE--------------------------------------------------------
suppressPackageStartupMessages(library(org.Mm.eg.db))

## ------------------------------------------------------------------------
keys <- unique(loc_mm10$GENEID)
head(select(org.Mm.eg.db, keys, cols, keytype="ENSEMBL"))

## ------------------------------------------------------------------------
hub <- AnnotationHub()
filters(hub) <- list(Species = "Homo sapiens")
hg19_files <- names(hub)[grepl("hg19", names(hub))]
length(hg19_files)

## ----, echo=FALSE--------------------------------------------------------
ov_hg19 <- lapply(hg19_files[1:3], 
             function(x) 
               subsetByOverlaps(hub[[x]], gr_hg19))

## ------------------------------------------------------------------------
names(ov_hg19) <- hg19_files[1:3]
lapply(ov_hg19, head, n=3)

## ----, echo=FALSE--------------------------------------------------------
suppressPackageStartupMessages(library(BSgenome.Hsapiens.UCSC.hg19))

## ------------------------------------------------------------------------
head(predictCoding(vcf, txdb_hg19, Hsapiens), 3)

## ----, echo=FALSE--------------------------------------------------------
suppressPackageStartupMessages(library(ensemblVEP))

## ------------------------------------------------------------------------
library(ensemblVEP)
fl <- system.file("extdata", "ex2.vcf", 
                  package="VariantAnnotation")

## ----, echo=FALSE--------------------------------------------------------
gr <- ensemblVEP(fl)

## ------------------------------------------------------------------------
head(gr, 3)

