/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.impl.level3.EntityReferenceImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityReference;

public class Group
extends EntityReferenceImpl {
    Set<EntityReference> members = new HashSet<EntityReference>();
    Set<Group> subgroups = new HashSet<Group>();
    boolean isComplex;
    Class<? extends BioPAXElement> genericClass;
    Set<BioPAXElement> sources;

    Group(boolean type, BioPAXElement source) {
        this.isComplex = type;
        this.sources = new HashSet<BioPAXElement>();
        this.sources.add(source);
    }

    @Override
    public String getRDFId() {
        return "http://biopax.org/generated/group/" + this.hashCode();
    }

    @Override
    public boolean isEquivalent(BioPAXElement element) {
        return this.equals(element);
    }

    @Override
    public int equivalenceCode() {
        return this.hashCode();
    }

    public void addMember(EntityReference member) {
        this.members.add(member);
    }

    public void addSubgroup(Group subgroup) {
        if (subgroup == this) {
            throw new IllegalArgumentException();
        }
        this.subgroups.add(subgroup);
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Group) {
            Group that = (Group)o;
            if (this.isEmpty()) {
                return this.sources.equals(that.sources);
            }
            return this.isComplex == that.isComplex && this.members.equals(that.members) && this.subgroups.equals(that.subgroups);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = this.isEmpty() ? (this.sources.isEmpty() ? super.hashCode() : this.sources.hashCode()) : this.members.hashCode() / 17 + this.subgroups.hashCode() / 23 + (this.isComplex ? 19 : 47);
        return code;
    }

    public boolean isEmpty() {
        return this.members.isEmpty() && this.subgroups.isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.isComplex).append("{");
        if (!this.isEmpty()) {
            for (EntityReference member : this.members) {
                bldr.append(member.getRDFId()).append(",");
            }
            for (Group subgroup : this.subgroups) {
                bldr.append(subgroup.toString()).append(",");
            }
            bldr.deleteCharAt(bldr.length() - 1);
        }
        return bldr.append("}").toString();
    }

    @Override
    public Map<String, Object> getAnnotations() {
        throw new UnsupportedOperationException("getAnnotations() is not supported for this (special) BioPAXElement: " + this.getClass());
    }

    public String groupTypeToString() {
        if (this.isComplex) {
            return "ComplexGroup";
        }
        return "Generic" + (this.genericClass == null ? "" : this.genericClass.getSimpleName());
    }

    public Set<EntityReference> getAllSimpleMembers() {
        HashSet<EntityReference> simples = new HashSet<EntityReference>();
        this.recursivelyGetMembers(simples);
        return simples;
    }

    private void recursivelyGetMembers(Set<EntityReference> simples) {
        for (EntityReference member : this.members) {
            simples.add(member);
        }
        for (Group subgroup : this.subgroups) {
            subgroup.recursivelyGetMembers(simples);
        }
    }
}

