/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.biopax.paxtools.controller.PropertyAccessorAdapter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class SimplePropertyAccessor<D extends BioPAXElement, R>
extends PropertyAccessorAdapter<D, R> {
    protected final Method getMethod;

    public SimplePropertyAccessor(Class<D> domain, Class<R> range, boolean multipleCardinality, Method getMethod) {
        super(domain, range, multipleCardinality);
        this.getMethod = getMethod;
    }

    protected static boolean isMultipleCardinality(Method getMethod) {
        return Set.class.isAssignableFrom(getMethod.getReturnType());
    }

    @Override
    public Set<R> getValueFromBean(D bean) throws IllegalBioPAXArgumentException {
        Object value = null;
        try {
            if (this.getDomain().isInstance(bean)) {
                value = this.getMethod.invoke(bean, new Object[0]);
            }
        }
        catch (IllegalAccessException e2) {
            throw new IllegalBioPAXArgumentException("Could not invoke get method " + this.getMethod.getName() + " for " + bean, e2);
        }
        catch (IllegalArgumentException e3) {
            throw new IllegalBioPAXArgumentException("Could not invoke get method " + this.getMethod.getName() + " for " + bean, e3);
        }
        catch (InvocationTargetException e4) {
            throw new IllegalBioPAXArgumentException("Could not invoke get method " + this.getMethod.getName() + " for " + bean, e4);
        }
        if (value == null) {
            return Collections.emptySet();
        }
        if (this.isMultipleCardinality()) {
            return Collections.unmodifiableSet((Set)value);
        }
        return Collections.singleton(value);
    }

    @Override
    public boolean isUnknown(Object value) {
        return value == null || value instanceof Set && ((Set)value).isEmpty();
    }
}

