/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.Type;
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;
import org.biopax.paxtools.pattern.miner.SIFEnum;

public class ControlsExpressionMiner
extends AbstractSIFMiner {
    public ControlsExpressionMiner() {
        super(SIFEnum.CONTROLS_EXPRESSION_OF);
    }

    public ControlsExpressionMiner(String nameSuppl, String descriptionSuppl) {
        super(SIFEnum.CONTROLS_EXPRESSION_OF, nameSuppl, descriptionSuppl);
    }

    @Override
    public Pattern constructPattern() {
        Pattern p = new Pattern(ProteinReference.class, "TF PR");
        p.add(ConBox.erToPE(), "TF PR", "TF simple PE");
        p.add(ConBox.linkToComplex(), "TF simple PE", "TF PE");
        p.add(ConBox.peToControl(), "TF PE", "Control");
        p.add(ConBox.controlToTempReac(), "Control", "TempReac");
        p.add((Constraint)new NOT(ConBox.participantER()), "TempReac", "TF PR");
        p.add(ConBox.product(), "TempReac", "product PE");
        p.add(ConBox.linkToSimple(), "product PE", "product simple PE");
        p.add((Constraint)new Type(Protein.class), "product simple PE");
        p.add(ConBox.peToER(), "product simple PE", "product PR");
        return p;
    }

    @Override
    public String getSourceLabel() {
        return "TF PR";
    }

    @Override
    public String getTargetLabel() {
        return "product PR";
    }

    @Override
    public String[] getMediatorLabels() {
        return new String[]{"Control", "TempReac"};
    }

    @Override
    public String[] getSourcePELabels() {
        return new String[]{"TF simple PE", "TF PE"};
    }

    @Override
    public String[] getTargetPELabels() {
        return new String[]{"product PE", "product simple PE"};
    }
}

