/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.util.HGNC;

public class CommonIDFetcher
implements IDFetcher {
    @Override
    public String fetchID(BioPAXElement ele) {
        if (ele instanceof SmallMoleculeReference) {
            SmallMoleculeReference smr = (SmallMoleculeReference)ele;
            if (smr.getDisplayName() != null) {
                return smr.getDisplayName();
            }
            if (!smr.getName().isEmpty()) {
                return smr.getName().iterator().next();
            }
            return null;
        }
        if (ele instanceof XReferrable) {
            for (Xref xr : ((XReferrable)ele).getXref()) {
                String symbol;
                String id;
                String db = xr.getDb();
                if (db == null || !(db = db.toLowerCase()).startsWith("hgnc") || (id = xr.getId()) == null || (symbol = HGNC.getSymbol(id)) == null || symbol.isEmpty()) continue;
                return symbol;
            }
        }
        return null;
    }
}

