/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.io.sif.level3.GroupMap;
import org.biopax.paxtools.io.sif.level3.PEStateChange;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.util.EquivalenceGrouper;

public class Simplify {
    private static Log log = LogFactory.getLog(Simplify.class);
    private static PathAccessor complexPath = new PathAccessor("Complex/component*");
    private static PathAccessor memberPath = new PathAccessor("PhysicalEntity/memberPhysicalEntity*");

    public static boolean entityHasAChange(BioPAXElement element, Conversion conv, GroupMap map, Set<PEStateChange> changeSet, Map<Conversion, Set<EntityReference>> extendedControls) {
        SimplePhysicalEntity left = null;
        SimplePhysicalEntity right = null;
        PhysicalEntity leftRoot = null;
        PhysicalEntity rightRoot = null;
        if (element == null) {
            if (log.isWarnEnabled()) {
                log.warn("Skipping ");
            }
            return false;
        }
        for (PhysicalEntity pe : conv.getLeft()) {
            left = Simplify.getAssociatedState(element, pe, map);
            if (left == null) continue;
            leftRoot = pe;
            break;
        }
        for (PhysicalEntity pe : conv.getRight()) {
            right = Simplify.getAssociatedState(element, pe, map);
            if (right == null) continue;
            rightRoot = pe;
            break;
        }
        if (left == null || right == null || !leftRoot.equals(rightRoot)) {
            if (changeSet != null) {
                changeSet.add(new PEStateChange(left, right, leftRoot, rightRoot, element, conv));
                if (extendedControls != null) {
                    Simplify.captureExtendedControls(conv, extendedControls, leftRoot, rightRoot);
                }
            }
            return true;
        }
        return false;
    }

    private static void captureExtendedControls(Conversion conv, Map<Conversion, Set<EntityReference>> extendedControls, PhysicalEntity leftRoot, PhysicalEntity rightRoot) {
        if ((leftRoot instanceof Complex || rightRoot instanceof Complex) && conv.getControlledOf().isEmpty()) {
            HashSet<SimplePhysicalEntity> leftSpe = new HashSet<SimplePhysicalEntity>();
            Simplify.getSimpleMembers(leftRoot, leftSpe);
            EquivalenceGrouper<SimplePhysicalEntity> leftComps = new EquivalenceGrouper<SimplePhysicalEntity>(leftSpe);
            HashSet<SimplePhysicalEntity> rightSpe = new HashSet<SimplePhysicalEntity>();
            Simplify.getSimpleMembers(rightRoot, rightSpe);
            EquivalenceGrouper<SimplePhysicalEntity> rightComps = new EquivalenceGrouper<SimplePhysicalEntity>(rightSpe);
            leftComps.getBuckets().retainAll(rightComps.getBuckets());
            for (List<SimplePhysicalEntity> bucket : leftComps.getBuckets()) {
                SimplePhysicalEntity pe = bucket.get(0);
                Set<EntityReference> erSet = extendedControls.get(conv);
                if (erSet == null) {
                    erSet = new HashSet<EntityReference>();
                    extendedControls.put(conv, erSet);
                }
                erSet.add(pe.getEntityReference());
            }
        }
    }

    public static void getSimpleMembers(PhysicalEntity root, Set<SimplePhysicalEntity> value) {
        if (root != null) {
            if (root instanceof Complex) {
                Complex complex2 = (Complex)root;
                for (PhysicalEntity component : complex2.getComponent()) {
                    Simplify.getSimpleMembers(component, value);
                }
            }
            if (root.getMemberPhysicalEntity().isEmpty()) {
                if (root instanceof SimplePhysicalEntity) {
                    value.add((SimplePhysicalEntity)root);
                }
            } else {
                for (PhysicalEntity generic : root.getMemberPhysicalEntity()) {
                    Simplify.getSimpleMembers(generic, value);
                }
            }
        }
    }

    private static SimplePhysicalEntity getAssociatedState(BioPAXElement element, PhysicalEntity pe, GroupMap map) {
        if (pe instanceof Complex) {
            for (PhysicalEntity component : ((Complex)pe).getComponent()) {
                SimplePhysicalEntity viaComplex = Simplify.getAssociatedState(element, component, map);
                if (viaComplex == null) continue;
                return viaComplex;
            }
        } else if (Simplify.checkEntity(map, pe, element)) {
            return (SimplePhysicalEntity)pe;
        }
        for (PhysicalEntity member : pe.getMemberPhysicalEntity()) {
            SimplePhysicalEntity viaGeneric = Simplify.getAssociatedState(element, member, map);
            if (viaGeneric == null) continue;
            return viaGeneric;
        }
        return null;
    }

    private static boolean checkEntity(GroupMap map, PhysicalEntity pe, BioPAXElement element) {
        return pe instanceof SimplePhysicalEntity && element.equals(((SimplePhysicalEntity)pe).getEntityReference()) || element.equals(map.getEntityReferenceOrGroup(pe));
    }

    public static boolean entityHasAChange(BioPAXElement target, Conversion conv, GroupMap groupMap, Set<PEStateChange> peStateChanges) {
        return Simplify.entityHasAChange(target, conv, groupMap, peStateChanges, null);
    }
}

