/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public class Cloner
implements Visitor {
    Traverser traverser;
    private BioPAXFactory factory;
    private Model targetModel;

    public Cloner(EditorMap map, BioPAXFactory factory) {
        this.factory = factory;
        this.traverser = new Traverser(map, this, new Filter[0]);
    }

    public Model clone(Model source, Set<BioPAXElement> toBeCloned) {
        this.targetModel = this.factory.createModel();
        for (BioPAXElement bpe : toBeCloned) {
            this.targetModel.addNew(bpe.getModelInterface(), bpe.getRDFId());
        }
        for (BioPAXElement bpe : toBeCloned) {
            this.traverser.traverse(bpe, source);
        }
        return this.targetModel;
    }

    public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
        BioPAXElement targetDomain = this.targetModel.getByID(domain.getRDFId());
        if (range instanceof BioPAXElement) {
            BioPAXElement bpe = (BioPAXElement)range;
            BioPAXElement existing = this.targetModel.getByID(bpe.getRDFId());
            if (existing != null) {
                editor.setValueToBean(existing, targetDomain);
            }
        } else {
            editor.setValueToBean(range, targetDomain);
        }
    }
}

