/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.xml.transform.stream.StreamSource;

public final class DataSourceSource
extends StreamSource {
    private final DataSource source;
    private final String charset;

    public DataSourceSource(DataHandler dh) throws MimeTypeParseException {
        this(dh.getDataSource());
    }

    public DataSourceSource(DataSource source) throws MimeTypeParseException {
        this.source = source;
        String ct = source.getContentType();
        if (ct == null) {
            this.charset = null;
        } else {
            MimeType mimeType = new MimeType(ct);
            this.charset = mimeType.getParameter("charset");
        }
    }

    public void setReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    public void setInputStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public Reader getReader() {
        try {
            if (this.charset == null) {
                return null;
            }
            return new InputStreamReader(this.source.getInputStream(), this.charset);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public InputStream getInputStream() {
        try {
            if (this.charset == null) {
                return this.source.getInputStream();
            }
            return null;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public DataSource getDataSource() {
        return this.source;
    }
}

