/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProcessBinding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;

public class QueryIterFilterExpr
extends QueryIterProcessBinding {
    private final Expr expr;

    public QueryIterFilterExpr(QueryIterator input, Expr expr, ExecutionContext context) {
        super(input, context);
        this.expr = expr;
    }

    public Binding accept(Binding binding) {
        try {
            if (this.expr.isSatisfied(binding, super.getExecContext())) {
                return binding;
            }
            return null;
        }
        catch (ExprException ex) {
            return null;
        }
        catch (Exception ex) {
            ALog.warn(this, "General exception in " + this.expr, (Throwable)ex);
            return null;
        }
    }

    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Utils.className(this));
        out.print(" ");
        ExprUtils.fmtSPARQL(out, this.expr, cxt);
    }
}

