## ------------------------------------------------------------------------
library(pandaR)
data(pandaToyData)

## ------------------------------------------------------------------------
pandaResult <- panda(pandaToyData$motif, pandaToyData$expression, pandaToyData$ppi)
pandaResult

## ------------------------------------------------------------------------
topNet <- topedges(pandaResult, 1000)

## ------------------------------------------------------------------------
targetedGenes(topNet, c("AR"))

## ------------------------------------------------------------------------
topSubnet <- subnetwork(topNet, c("AR","ARID3A","ELK1"))

## ------------------------------------------------------------------------
plotGraph(topSubnet)

## ------------------------------------------------------------------------
sessionInfo()

