/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.Printing;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.tableau.Node;

public class NodesForCommand
extends AbstractCommand {
    public NodesForCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "nodesFor";
    }

    public String[] getDescription() {
        return new String[]{"conceptName", "prints nodes that have been created by (atleast n r.conceptName)"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: nodesFor conceptName");
        printWriter.println("    Prints all nodes that have been created by a concept (atleast n r.conceptName)");
        printWriter.println("    together with the information whether the nodes are active or not.");
    }

    public void execute(String[] stringArray) {
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("Concept name is missing.");
            return;
        }
        String string = stringArray[1];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        AtomicConcept atomicConcept = null;
        try {
            atomicConcept = AtomicConcept.create(this.m_debugger.getPrefixes().expandAbbreviatedIRI(string));
            printWriter.println("Nodes for '" + string + "'");
            printWriter.println("====================================================================");
            int n = 0;
            for (Node node = this.m_debugger.getTableau().getFirstTableauNode(); node != null; node = node.getNextTableauNode()) {
                Debugger.NodeCreationInfo nodeCreationInfo = this.m_debugger.getNodeCreationInfo(node);
                ExistentialConcept existentialConcept = nodeCreationInfo.m_createdByExistential;
                if (!(existentialConcept instanceof AtLeastConcept) || !((AtLeastConcept)existentialConcept).getToConcept().equals(atomicConcept)) continue;
                if (n != 0) {
                    printWriter.print(",");
                    if (n % 5 == 0) {
                        printWriter.println();
                    } else {
                        printWriter.print("  ");
                    }
                }
                Printing.printPadded(printWriter, node.getNodeID() + (node.isActive() ? "" : "*"), 8);
                ++n;
            }
            printWriter.println();
            printWriter.println("====================================================================");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            printWriter.println(string + " is invalid: " + illegalArgumentException.getMessage());
        }
        printWriter.flush();
        this.showTextInWindow(charArrayWriter.toString(), "Nodes for '" + string + "'");
        this.selectConsoleWindow();
    }
}

