/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.owlapi.obo.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo.parser.OBOConsumer;
import org.coode.owlapi.obo.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymTagValueHandler
extends AbstractTagValueHandler {
    private static final String TAG_NAME = OBOVocabulary.SYNONYM.toString();
    private static final Pattern valuePattern = Pattern.compile("\"([^\"]*)\"\\s*([^\\s]*)\\s*\\[([^\\]]*)\\]");
    private static final int VALUE_GROUP = 1;
    private static final int TYPE_GROUP = 2;
    private static final int XREF_GROUP = 3;
    public static final IRI SYNONYM_TYPE_IRI = OBOVocabulary.SYNONYM_TYPE.getIRI();
    public static final IRI XREF_IRI = OBOVocabulary.XREF.getIRI();

    public SynonymTagValueHandler(OBOConsumer consumer) {
        super(TAG_NAME, consumer);
    }

    @Override
    public void handle(String id, String value, String comment) {
        Matcher matcher = valuePattern.matcher(value);
        if (matcher.matches()) {
            IRI synonymIRI = this.getTagIRI(TAG_NAME);
            OWLDataFactory df = this.getDataFactory();
            OWLAnnotationProperty property = df.getOWLAnnotationProperty(synonymIRI);
            HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
            OWLAnnotation typeAnnotation = this.getSynonymTypeAnnotation(matcher);
            annotations.add(typeAnnotation);
            annotations.addAll(this.getXRefAnnotations(matcher, df));
            OWLEntity subject = this.getConsumer().getCurrentEntity();
            String synonym = matcher.group(1);
            OWLLiteral synonymLiteral = df.getOWLLiteral(synonym, "");
            OWLAnnotationAssertionAxiom annoAssertion = df.getOWLAnnotationAssertionAxiom(property, subject.getIRI(), synonymLiteral, annotations);
            this.applyChange(new AddAxiom(this.getOntology(), annoAssertion));
        }
    }

    private Set<OWLAnnotation> getXRefAnnotations(Matcher matcher, OWLDataFactory df) {
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        String xrefs = matcher.group(3);
        if (xrefs != null) {
            StringTokenizer tokenizer = new StringTokenizer(xrefs, ",");
            while (tokenizer.hasMoreTokens()) {
                String xref = tokenizer.nextToken();
                IRI xrefIRI = this.getTagIRI(xref);
                OWLAnnotationProperty xrefProperty = df.getOWLAnnotationProperty(XREF_IRI);
                OWLAnnotation xrefAnnotation = df.getOWLAnnotation(xrefProperty, xrefIRI);
                annotations.add(xrefAnnotation);
            }
        }
        return annotations;
    }

    private OWLAnnotation getSynonymTypeAnnotation(Matcher matcher) {
        OWLDataFactory df = this.getDataFactory();
        String synonymType = matcher.group(2);
        return df.getOWLAnnotation(df.getOWLAnnotationProperty(SYNONYM_TYPE_IRI), df.getOWLLiteral(synonymType));
    }
}

