### R code from vignette source 'nondetects.Rnw'

###################################################
### code chunk number 1: nondetects.Rnw:84-87
###################################################
library(HTqPCR)
library(nondetects)
data(oncogene2013)


###################################################
### code chunk number 2: nondetects.Rnw:92-94
###################################################
normCt <- normalizeCtData(oncogene2013, norm = "deltaCt", 
                          deltaCt.genes = "Becn1")


###################################################
### code chunk number 3: nondetects.Rnw:98-106
###################################################
conds <- paste(pData(normCt)$sampleType,pData(normCt)$treatment,sep=":")
resids <- matrix(nrow=nrow(normCt), ncol=ncol(normCt))
for(i in 1:nrow(normCt)){
  for(j in 1:ncol(normCt)){
    ind <- which(conds==conds[j])
    resids[i,j] <- exprs(normCt)[i,j]-mean(exprs(normCt)[i,ind])
  }
}


###################################################
### code chunk number 4: nondetects.Rnw:110-113
###################################################
iND <- which(featureCategory(normCt)=="Undetermined", arr.ind=TRUE)
iD <- which(featureCategory(normCt)!="Undetermined", arr.ind=TRUE)
boxes <- list("observed"=-resids[iD], "non-detect"=-resids[iND])


###################################################
### code chunk number 5: nondetects.Rnw:115-117
###################################################
boxplot(boxes, main="",ylim=c(-12,12),
        ylab=expression(paste("-",Delta,"Ct residuals",sep="")))


###################################################
### code chunk number 6: nondetects.Rnw:121-123
###################################################
oncogene2013 <- qpcrImpute(oncogene2013, 
                           groupVars=c("sampleType","treatment"))


###################################################
### code chunk number 7: nondetects.Rnw:128-130
###################################################
normCt <- normalizeCtData(oncogene2013, norm = "deltaCt", 
                          deltaCt.genes = "Becn1")


###################################################
### code chunk number 8: nondetects.Rnw:134-135
###################################################
normCt <- normCt[-which(featureNames(normCt)=="Becn1"),]


###################################################
### code chunk number 9: nondetects.Rnw:139-148
###################################################
conds <- paste(pData(normCt)$sampleType,
               pData(normCt)$treatment,sep=":")
resids <- matrix(nrow=nrow(normCt), ncol=ncol(normCt))
for(i in 1:nrow(normCt)){
  for(j in 1:ncol(normCt)){
    ind <- which(conds==conds[j])
    resids[i,j] <- exprs(normCt)[i,j]-mean(exprs(normCt)[i,ind])
  }
}


###################################################
### code chunk number 10: nondetects.Rnw:152-155
###################################################
iI <- which(featureCategory(normCt)=="Imputed", arr.ind=TRUE)
iD <- which(featureCategory(normCt)!="Imputed", arr.ind=TRUE)
boxes <- list("observed"=-resids[iD], "imputed"=-resids[iI])


###################################################
### code chunk number 11: nondetects.Rnw:157-159
###################################################
boxplot(boxes, main="",ylim=c(-12,12),
        ylab=expression(paste("-",Delta,"Ct residuals",sep="")))


###################################################
### code chunk number 12: nondetects.Rnw:175-177
###################################################
library(nondetects)
data(sagmb2011)


###################################################
### code chunk number 13: nondetects.Rnw:188-190
###################################################
library(nondetects)
data(nature2008)


###################################################
### code chunk number 14: nondetects.Rnw:199-200
###################################################
sessionInfo()


