### R code from vignette source 'inSilicoDb.Rnw'

###################################################
### code chunk number 1: example_getDatasets
###################################################
library("inSilicoDb");
InSilicoLogin("rpackage_tester@insilicodb.com", "5c4d0b231e5cba4a0bc54783b385cc9a");
res = getDatasets("GSE4635");
eset = res[[1]];


###################################################
### code chunk number 2: example_getDataset
###################################################
eset = getDataset("GSE4635", "GPL96");


###################################################
### code chunk number 3: example_getPlatforms
###################################################
platforms = getPlatforms("GSE4635");
print(platforms);


###################################################
### code chunk number 4: example_heatmap
###################################################
#eset = getDataset("GSE4635", "GPL96",  features = "gene");
#heatmap(exprs(eset)[1:100,]);
library("limma")

eset = getDataset("GSE4635", "GPL96",
                  norm="FRMA", features = "gene");
                      
# Find 50 most discriminating genes
f = pData(eset)[ ,"Smoker"]
design = model.matrix(~f);
fit = eBayes(lmFit(eset,design));
t = topTable(fit, coef=2, number=50);
selected = is.element(rownames(exprs(eset)),
                         t[ ,"SYMBOL"])
eset = eset[selected, ];
  
labels = pData(eset)[,"Smoker"];
heatmap(exprs(eset), labCol=labels);


###################################################
### code chunk number 5: example_getAnnotations
###################################################
annot = getAnnotations("GSE4635", "GPL96");
pData(annot);


###################################################
### code chunk number 6: example_getDataset_norm
###################################################
eset = getDataset("GSE4635", "GPL96", norm="FRMA");


###################################################
### code chunk number 7: example_getDataset_genes
###################################################
eset = getDataset("GSE4635", "GPL96");
print(nrow(eset));
eset = getDataset("GSE4635", "GPL96", features="gene");
print(nrow(eset));


###################################################
### code chunk number 8: example_analysis
###################################################
lst = list("GSE4635", "GSExxx", "GSE781");
gpl = "GPL96";

for(gse in lst)
{
  catn = function(...) { cat(...,"\n"); } 
  catn("Processing",gse);
  catn("=======================");
  eset = tryCatch({getDataset(gse, gpl);},
                  error = function(x) { print(as.character(x)); NULL; });
  if(is.null(eset)) { next; }
  catn("Number of annotations:");
  catn(ncol(pData(eset)));
  catn("Number of missing values:");
  catn(sum(is.na(exprs(eset))));
}


###################################################
### code chunk number 9: inSilicoDb.Rnw:147-148
###################################################
sessionInfo()


