### R code from vignette source 'graphite.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: startup
###################################################
library(graph)
library(graphite)


###################################################
### code chunk number 3: base1
###################################################
humanReactome <- pathways("hsapiens", "reactome")
names(humanReactome)[1:10]
p <- humanReactome[["ABC-family proteins mediated transport"]]
p


###################################################
### code chunk number 4: base2
###################################################
p <- humanReactome[[21]]
p@title


###################################################
### code chunk number 5: base3
###################################################
head(nodes(p))


###################################################
### code chunk number 6: base4
###################################################
head(edges(p))


###################################################
### code chunk number 7: base5
###################################################
pathwayDatabases()


###################################################
### code chunk number 8: graph1
###################################################
g <- pathwayGraph(p)
g


###################################################
### code chunk number 9: graph2
###################################################
edgeData(g)[1]


###################################################
### code chunk number 10: ident1
###################################################
pSymbol <- convertIdentifiers(p, "SYMBOL")
pSymbol
head(nodes(pSymbol))


###################################################
### code chunk number 11: ident2
###################################################
reactomeSymbol <- convertIdentifiers(humanReactome[1:5], "SYMBOL")


###################################################
### code chunk number 12: spia1
###################################################
library(SPIA)
data(colorectalcancer)

library(hgu133plus2.db)
x <- hgu133plus2ENTREZID
top$ENTREZ <- unlist(as.list(x[top$ID]))
top <- top[!is.na(top$ENTREZ), ]
top <- top[!duplicated(top$ENTREZ), ]
tg1 <- top[top$adj.P.Val < 0.05, ]

DE_Colorectal = tg1$logFC
names(DE_Colorectal) <- as.vector(tg1$ENTREZ)
ALL_Colorectal <- top$ENTREZ

prepareSPIA(biocarta[1:2], "biocartaEx")
res <- runSPIA(de=DE_Colorectal, all=ALL_Colorectal, "biocartaEx")
res


###################################################
### code chunk number 13: dg1
###################################################
library(DEGraph)
data("Loi2008_DEGraphVignette")

biocarta <- pathways("hsapiens", "biocarta")
p <- convertIdentifiers(biocarta[["actions of nitric oxide in the heart"]], "ENTREZID")
res <- runDEGraph(p, exprLoi2008, classLoi2008)
res$`1`


###################################################
### code chunk number 14: tg1
###################################################
library(topologyGSA)
data(examples)

kegg <- pathways("hsapiens", "kegg")
p <- convertIdentifiers(kegg[["Fc epsilon RI signaling pathway"]], "SYMBOL")
runTopologyGSA(p, "var", y1, y2, 0.05)


###################################################
### code chunk number 15: tg1
###################################################
library(clipper)
library(ALL)

kegg <- pathways("hsapiens", "kegg")
paths <-convertIdentifiers(kegg[1:5], "ENTREZID")
genes <- unlist(lapply(paths, nodes))
data(ALL)
all <- as.matrix(exprs(ALL[1:length(genes),1:20]))
classes <- c(rep(1,10), rep(2,10))
rownames(all) <- genes
clipped <- runClipper(paths, all, classes, "mean", pathThr=0.1)
resClip <- do.call(rbind,clipped$results)
resClip[,1:5]


