### R code from vignette source 'genome-tables.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(genomes)
options(warn=-1, width=75, digits=2, scipen=3,  "prompt" = "R> ", "continue" = " ")
options(SweaveHooks=list(fig=function() par(mar=c(5,4.2,1,1))))


###################################################
### code chunk number 2: proks
###################################################
data(proks)
proks
summary(proks)
plot(proks, log='y', las=1)



###################################################
### code chunk number 3: update (eval = FALSE)
###################################################
## update(proks)


###################################################
### code chunk number 4: table2
###################################################
spp<-species(proks$name)
table2(spp)


###################################################
### code chunk number 5: yersinia
###################################################
getOption("SweaveHooks")[["fig"]]()
## Yersinia pestis
yp<-subset(proks, name %like% 'Yersinia pestis*' & year(released)<2012 )
plotby(yp, labels=TRUE, cex=.5, lbty='n', curdate=FALSE)



