### R code from vignette source 'flowWorkspace.Rnw'

###################################################
### code chunk number 1: loadlib
###################################################
library(flowWorkspace)


###################################################
### code chunk number 2: findxml
###################################################
d<-system.file("extdata",package="flowWorkspaceData");
wsfile<-list.files(d,pattern="A2004Analysis.xml",full=T)


###################################################
### code chunk number 3: openws
###################################################
ws<-openWorkspace(wsfile)
ws


###################################################
### code chunk number 4: parsews
###################################################
G<-parseWorkspace(ws,name=1,path=ws@path,isNcdf=FALSE,cleanup=FALSE,keep.indices=TRUE); #import the first group
#Lots of output here suppressed for the vignette.


###################################################
### code chunk number 5: summary
###################################################
G


###################################################
### code chunk number 6: plotGH
###################################################
gh<-G[[1]]
plot(gh)


###################################################
### code chunk number 7: getNodes
###################################################
nodelist<-getNodes(gh, path = 1)
nodelist


###################################################
### code chunk number 8: getNodes-prefix
###################################################
getNodes(gh, prefix="all", path = 1)


###################################################
### code chunk number 9: getNodes-path
###################################################
getNodes(gh, path = "full")


###################################################
### code chunk number 10: getGate
###################################################
node<-nodelist[3]
g<-getGate(gh,node)
g


###################################################
### code chunk number 11: getProp
###################################################
getProp(gh,node)


###################################################
### code chunk number 12: getStats
###################################################
getPopStats(gh)


###################################################
### code chunk number 13: plotPCV
###################################################
print(plotPopCV(gh))


###################################################
### code chunk number 14: plotGate-numeric (eval = FALSE)
###################################################
## plotGate(gh, 10)


###################################################
### code chunk number 15: plotGate-nodeName (eval = FALSE)
###################################################
## plotGate(gh, "pDC")


###################################################
### code chunk number 16: plotGate-path
###################################################
plotGate(gh, "APC/pDC")


###################################################
### code chunk number 17: plotGate
###################################################
plotGate(gh, "pDC", xbin =32)


###################################################
### code chunk number 18: plotGate-overlay
###################################################
plotGate(gh,y = "pDC/IL-12+", xbin =32, overlay = "mDC/IL-12+")


###################################################
### code chunk number 19: annotate
###################################################
d<-data.frame(sample=factor(c("sample 1", "sample 2")),treatment=factor(c("sample","control")) )
pd<-pData(G)
pd<-cbind(pd,d)
pData(G)<-pd
pData(G);


###################################################
### code chunk number 20: getData-gh
###################################################
getData(gh,node)


###################################################
### code chunk number 21: getData-G
###################################################
getData(G,node);


###################################################
### code chunk number 22: getInd
###################################################
table(getIndices(gh,node))


###################################################
### code chunk number 23: getCMAT
###################################################
C<-getCompensationMatrices(gh);
C


###################################################
### code chunk number 24: getTrans
###################################################
T<-getTransformations(gh)
names(T)
T[[1]]


###################################################
### code chunk number 25: tnames
###################################################
A<-names(T)
B<-names(T[[1]])


###################################################
### code chunk number 26: getsamples
###################################################
getSamples(ws);


###################################################
### code chunk number 27: getgroups
###################################################
getSampleGroups(ws)


###################################################
### code chunk number 28: create gs
###################################################
data(GvHD)
#select raw flow data
fs<-GvHD[1:3]


###################################################
### code chunk number 29: transform
###################################################
tf <- transformList(colnames(fs[[1]])[3:6], asinh, transformationId="asinh")
fs_trans<-transform(fs,tf)


###################################################
### code chunk number 30: create gs
###################################################
gs <- GatingSet(fs_trans)
gs
gh1<-gs[[1]]
getNodes(gh1) 


###################################################
### code chunk number 31: add-rectGate
###################################################
rg <- rectangleGate("FSC-H"=c(200,400), "SSC-H"=c(250, 400),
                    filterId="rectangle")

nodeID<-add(gs, rg)
nodeID
getNodes(gh1)  


###################################################
### code chunk number 32: add-quadGate
###################################################
qg <- quadGate("FL1-H"=2, "FL2-H"=4)
nodeIDs<-add(gs,qg,parent="rectangle")
nodeIDs 
getNodes(gh1)


###################################################
### code chunk number 33: add-boolGate
###################################################
bg<-booleanFilter(`CD15 FITC-CD45 PE+|CD15 FITC+CD45 PE-`)
bg
nodeID2<-add(gs,bg,parent="rectangle")
nodeID2
getNodes(gh1)


###################################################
### code chunk number 34: recompute
###################################################
recompute(gs)


###################################################
### code chunk number 35: plotGate-rect
###################################################
plotGate(gh1,"rectangle") #plot one Gate


###################################################
### code chunk number 36: plotGate-multiple
###################################################
plotGate(gh1,nodeIDs) 


###################################################
### code chunk number 37: plotGate-gh-all
###################################################
plotGate(gh1)


###################################################
### code chunk number 38: plotGate-gh-bool (eval = FALSE)
###################################################
## plotGate(gh1,bool=TRUE)


###################################################
### code chunk number 39: plotGate-gs
###################################################
plotGate(gs,getNodes(gs)[nodeID])


###################################################
### code chunk number 40: plot-gh (eval = FALSE)
###################################################
## plot(gh1,bool=TRUE)


###################################################
### code chunk number 41: rm
###################################################
Rm('rectangle', gs)
getNodes(gh1)


###################################################
### code chunk number 42: archive (eval = FALSE)
###################################################
## 	save_gs(gs,file = "~/gs")
## 	G1 <- load_gs(file = "~/gs")


###################################################
### code chunk number 43: clone (eval = FALSE)
###################################################
## 	gs_cloned <- clone(gs)


