### R code from vignette source 'cleanUpdTSeq.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: 1
###################################################
library(cleanUpdTSeq)
testFile <- system.file("extdata", "test.bed", package="cleanUpdTSeq")
testSet <- read.table(testFile, sep="\t", header=TRUE)
peaks <- BED2GRangesSeq(testSet, withSeq=FALSE)


###################################################
### code chunk number 3: 2
###################################################
peaks <- BED2GRangesSeq(testSet, upstream.seq.ind=7, 
                          downstream.seq.ind=8, withSeq=TRUE)


###################################################
### code chunk number 4: 3
###################################################
head(testSet)


###################################################
### code chunk number 5: 4
###################################################
testSet.NaiveBayes <- buildFeatureVector(peaks, BSgenomeName=Drerio,
                                         upstream=40, downstream=30, 
                                         wordSize=6, alphabet=c("ACGT"),
                                         sampleType="unknown", 
                                         replaceNAdistance=30, 
                                         method="NaiveBayes",
                                         ZeroBasedIndex=1, fetchSeq=TRUE)


###################################################
### code chunk number 6: 5
###################################################
data(data.NaiveBayes)
if(interactive()){
    predictTestSet(data.NaiveBayes$Negative, data.NaiveBayes$Positive, 
                   testSet.NaiveBayes=testSet.NaiveBayes, 
                   outputFile="test-predNaiveBayes.tsv", 
                   assignmentCutoff=0.5)
}


###################################################
### code chunk number 7: 6
###################################################
data(classifier)
testResults <- predictTestSet(testSet.NaiveBayes=testSet.NaiveBayes,
                              classifier=classifier,
                              outputFile=NULL, 
                              assignmentCutoff=0.5)
head(testResults)


###################################################
### code chunk number 8: sessionInfo
###################################################
toLatex(sessionInfo())


