### R code from vignette source 'bioassayR.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: bioassayR.Rnw:72-74 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R") # Sources the biocLite.R installation script.
## biocLite("bioassayR") # Installs the package.


###################################################
### code chunk number 3: bioassayR.Rnw:79-80
###################################################
library(bioassayR) # Loads the package


###################################################
### code chunk number 4: bioassayR.Rnw:82-84 (eval = FALSE)
###################################################
## library(help="bioassayR") # Lists all functions and classes 
## vignette("bioassayR") # Opens this PDF manual from R


###################################################
### code chunk number 5: bioassayR.Rnw:95-99
###################################################
library(bioassayR)
library(RSQLite)
myDatabaseFilename <- tempfile() 
mydb <- newBioassayDB(myDatabaseFilename, indexed=F)


###################################################
### code chunk number 6: bioassayR.Rnw:104-105
###################################################
addDataSource(mydb, description="PubChem Bioassay", version="unknown")


###################################################
### code chunk number 7: bioassayR.Rnw:111-113
###################################################
data(samplebioassay)
samplebioassay[1:10,] # print the first 10 scores


###################################################
### code chunk number 8: bioassayR.Rnw:119-123
###################################################
myAssay <- new("bioassay",aid="1000", source_id="PubChem Bioassay",
    assay_type="confirmatory", organism="unknown", scoring="activity rank", 
    targets="116516899", target_types="protein", scores=samplebioassay)
myAssay


###################################################
### code chunk number 9: bioassayR.Rnw:129-130
###################################################
loadBioassay(mydb, myAssay)


###################################################
### code chunk number 10: bioassayR.Rnw:136-140
###################################################
tempAssay <- getAssay(mydb, "1000") # get assay from database
dropBioassay(mydb, "1000") # delete assay from database
organism(tempAssay) <- "Streptococcus pneumonia" # update organism
loadBioassay(mydb, tempAssay)


###################################################
### code chunk number 11: bioassayR.Rnw:145-146
###################################################
addBioassayIndex(mydb)


###################################################
### code chunk number 12: bioassayR.Rnw:151-152
###################################################
mydb


###################################################
### code chunk number 13: bioassayR.Rnw:157-158
###################################################
activeTargets(mydb, 16749979)


###################################################
### code chunk number 14: bioassayR.Rnw:165-166
###################################################
queryBioassayDB(mydb, "SELECT * FROM sqlite_master WHERE type='table'")


###################################################
### code chunk number 15: bioassayR.Rnw:171-172
###################################################
queryBioassayDB(mydb, "SELECT DISTINCT(aid) FROM activity WHERE cid = '16749979'")


###################################################
### code chunk number 16: bioassayR.Rnw:177-178
###################################################
queryBioassayDB(mydb, "SELECT * FROM activity WHERE aid = '1000' LIMIT 10")


###################################################
### code chunk number 17: bioassayR.Rnw:183-184
###################################################
disconnectBioassayDB(mydb)


###################################################
### code chunk number 18: bioassayR.Rnw:187-189
###################################################
# delete temporary database
unlink(myDatabaseFilename)


###################################################
### code chunk number 19: bioassayR.Rnw:197-201
###################################################
library(bioassayR)
extdata_dir <- system.file("extdata", package="bioassayR")
assayDescriptionFile <- file.path(extdata_dir, "exampleAssay.xml")
activityScoresFile <- file.path(extdata_dir, "exampleScores.csv")


###################################################
### code chunk number 20: bioassayR.Rnw:207-209
###################################################
myDatabaseFilename <- tempfile()
mydb <- newBioassayDB(myDatabaseFilename, indexed=F)


###################################################
### code chunk number 21: bioassayR.Rnw:213-214
###################################################
addDataSource(mydb, description="PubChem Bioassay", version="unknown")


###################################################
### code chunk number 22: bioassayR.Rnw:221-223
###################################################
myAssay <- parsePubChemBioassay("1000", activityScoresFile, assayDescriptionFile)
myAssay


###################################################
### code chunk number 23: bioassayR.Rnw:228-229
###################################################
loadBioassay(mydb, myAssay)


###################################################
### code chunk number 24: bioassayR.Rnw:234-235
###################################################
addBioassayIndex(mydb)


###################################################
### code chunk number 25: bioassayR.Rnw:240-241
###################################################
activeAgainst(mydb,"116516899")


###################################################
### code chunk number 26: bioassayR.Rnw:246-247
###################################################
disconnectBioassayDB(mydb)


###################################################
### code chunk number 27: bioassayR.Rnw:250-252
###################################################
# delete temporary database
unlink(myDatabaseFilename)


###################################################
### code chunk number 28: bioassayR.Rnw:257-301 (eval = FALSE)
###################################################
## # this is code for building the example database used here- it should not
## # be visible to the reader in the final PDF
## library(bioassayR)
## pubChemDatabase <- connectBioassayDB("working/bioassayDatabase.sqlite")
## sampleDB <- newBioassayDB("src/bioassayR/inst/extdata/sampleDatabase.sqlite", indexed=F)
## addDataSource(sampleDB, description="bioassayR_testdata", version="unknown")
## 
## # add activity rows
## activityRows <- queryBioassayDB(pubChemDatabase, "SELECT * FROM activity WHERE cid = '2244'")
## con <- slot(sampleDB, "database")
## sql <- paste("INSERT INTO activity VALUES ($aid, $cid, $sid, $activity, $score)", sep="")
## dbBeginTransaction(con)
## dbGetPreparedQuery(con, sql, bind.data = activityRows)
## dbCommit(con)
## 
## # add assay ids and targets
## for(aid in activityRows[,1]){
##     assay <- queryBioassayDB(pubChemDatabase, paste("select * from assays where aid =", aid))
##     target <- queryBioassayDB(pubChemDatabase, paste("select * from targets where aid =", aid))
##     if(nrow(target) == 1){
##         addAssayTarget(sampleDB, aid = aid, target=target$target, target_type=target$target_type)
##     }
##     addBioassay(sampleDB, source="bioassayR_testdata", aid=aid, assay_type=assay$assay_type, organism=assay$organism, scoring=assay$scoring)
## }
## 
## # load activity data for target 166897622
## assays <- queryBioassayDB(pubChemDatabase, "SELECT aid FROM targets WHERE target = '166897622'")[[1]]
## for(aid in assays[! assays %in% activityRows[,1]]){
##     assay <- queryBioassayDB(pubChemDatabase, paste("select * from assays where aid =", aid))
##     target <- queryBioassayDB(pubChemDatabase, paste("select * from targets where aid =", aid))
##     if(nrow(target) == 1){
##         addAssayTarget(sampleDB, aid = aid, target=target$target, target_type=target$target_type)
##     }
##     addBioassay(sampleDB, source="bioassayR_testdata", aid=aid, assay_type=assay$assay_type, organism=assay$organism, scoring=assay$scoring)
## 
##     activityRows <- queryBioassayDB(pubChemDatabase, paste("SELECT * FROM activity WHERE aid =", aid))
##     con <- slot(sampleDB, "database")
##     sql <- paste("INSERT INTO activity VALUES ($aid, $cid, $sid, $activity, $score)", sep="")
##     dbBeginTransaction(con)
##     dbGetPreparedQuery(con, sql, bind.data = activityRows)
##     dbCommit(con)
## }
## 
## disconnectBioassayDB(sampleDB)


###################################################
### code chunk number 29: bioassayR.Rnw:316-320
###################################################
library(bioassayR)
extdata_dir <- system.file("extdata", package="bioassayR")
sampleDatabasePath <- file.path(extdata_dir, "sampleDatabase.sqlite")
pubChemDatabase <- connectBioassayDB(sampleDatabasePath)  


###################################################
### code chunk number 30: bioassayR.Rnw:327-329
###################################################
drugTargets <- activeTargets(pubChemDatabase, "2244")
drugTargets


###################################################
### code chunk number 31: bioassayR.Rnw:335-337
###################################################
library(ape)
targetSequences <- read.GenBank(row.names(drugTargets), species.names = TRUE)


###################################################
### code chunk number 32: bioassayR.Rnw:341-342
###################################################
cbind(attr(targetSequences, "species"), names(targetSequences))


###################################################
### code chunk number 33: bioassayR.Rnw:357-361
###################################################
library(bioassayR)
extdata_dir <- system.file("extdata", package="bioassayR") 
sampleDatabasePath <- file.path(extdata_dir, "sampleDatabase.sqlite")
pubChemDatabase <- connectBioassayDB(sampleDatabasePath)  


###################################################
### code chunk number 34: bioassayR.Rnw:368-370
###################################################
activeCompounds <- activeAgainst(pubChemDatabase, "166897622")
activeCompounds[1:10,] # look at the first 10 compounds


###################################################
### code chunk number 35: bioassayR.Rnw:379-382
###################################################
selectiveCompounds <- selectiveAgainst(pubChemDatabase, "166897622", 
    maxCompounds = 10, minimumTargets = 1)
selectiveCompounds


###################################################
### code chunk number 36: bioassayR.Rnw:392-394
###################################################
library(ChemmineR)
structures <- getIds(as.numeric(row.names(selectiveCompounds)))


###################################################
### code chunk number 37: plotstruct
###################################################
plot(structures[1:4], print=FALSE) # Plots structures to R graphics device


###################################################
### code chunk number 38: bioassayR.Rnw:411-415
###################################################
library(bioassayR)
extdata_dir <- system.file("extdata", package="bioassayR") 
sampleDatabasePath <- file.path(extdata_dir, "sampleDatabase.sqlite")
sampleDB <- connectBioassayDB(sampleDatabasePath)  


###################################################
### code chunk number 39: bioassayR.Rnw:421-424
###################################################
compoundsOfInterest <- c("2244", "2662", "3715")
selectedAssayData <- getBioassaySetByCids(sampleDB, compoundsOfInterest)
selectedAssayData


###################################################
### code chunk number 40: bioassayR.Rnw:430-432
###################################################
myActivityMatrix <- perTargetMatrix(selectedAssayData)
myActivityMatrix


###################################################
### code chunk number 41: bioassayR.Rnw:439-442
###################################################
transposedMatrix <- t(myActivityMatrix)
distanceMatrix <- dist(transposedMatrix)
clusterResults <- hclust(distanceMatrix, method="average")


###################################################
### code chunk number 42: clusterResult
###################################################
plot(clusterResults)


###################################################
### code chunk number 43: bioassayR.Rnw:450-451
###################################################
disconnectBioassayDB(sampleDB)


###################################################
### code chunk number 44: bioassayR.Rnw:470-489
###################################################
library(cellHTS2)
library(bioassayR)

dataPath <- system.file("KcViab", package="cellHTS2")
x <- readPlateList("Platelist.txt", 
                   name="KcViab", 
                   path=dataPath)

x <- configure(x,
               descripFile="Description.txt", 
               confFile="Plateconf.txt", 
               logFile="Screenlog.txt", 
               path=dataPath)

xn <- normalizePlates(x, 
                      scale="multiplicative", 
                      log=FALSE, 
                      method="median", 
                      varianceAdjust="none")


###################################################
### code chunk number 45: bioassayR.Rnw:495-497
###################################################
xsc <- scoreReplicates(xn, sign="-", method="zscore")
xsc <- summarizeReplicates(xsc, summary="mean")


###################################################
### code chunk number 46: bioassayR.Rnw:503-504
###################################################
xsc <- annotate(xsc, geneIDFile="GeneIDs_Dm_HFA_1.1.txt", path=dataPath)


###################################################
### code chunk number 47: bioassayR.Rnw:510-512
###################################################
y <- scores2calls(xsc, z0=1.5, lambda=2)
binaryCalls <- round(Data(y))


###################################################
### code chunk number 48: bioassayR.Rnw:518-524
###################################################
scoreDataFrame <- cbind(geneAnno(y), binaryCalls)
scoreDataFrame <- scoreDataFrame[wellAnno(y) == "sample",]
activityTable <- cbind(cid=scoreDataFrame[,1], sid=scoreDataFrame[,1], 
     activity=scoreDataFrame[,2], score=Data(xsc))
activityTable <- as.data.frame(activityTable)
activityTable[1:10,]


###################################################
### code chunk number 49: bioassayR.Rnw:530-533
###################################################
myDatabaseFilename <- tempfile() 
mydb <- newBioassayDB(myDatabaseFilename, indexed=F)
addDataSource(mydb, description="other", version="unknown")


###################################################
### code chunk number 50: bioassayR.Rnw:539-542
###################################################
myAssay <- new("bioassay",aid="1", source_id="other",
     assay_type="confirmatory", organism="unknown", scoring="activity rank", 
     targets="2224444", target_types="protein", scores=activityTable)


###################################################
### code chunk number 51: bioassayR.Rnw:548-550
###################################################
loadBioassay(mydb, myAssay)
mydb


###################################################
### code chunk number 52: bioassayR.Rnw:557-558
###################################################
disconnectBioassayDB(mydb)


###################################################
### code chunk number 53: bioassayR.Rnw:561-563
###################################################
# delete temporary database
unlink(myDatabaseFilename)


###################################################
### code chunk number 54: sessionInfo
###################################################
toLatex(sessionInfo())


