/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphSelectionModel
extends mxEventSource {
    protected mxGraph graph;
    protected boolean singleSelection = false;
    protected Set<Object> cells = new LinkedHashSet<Object>();

    public mxGraphSelectionModel(mxGraph mxGraph2) {
        this.graph = mxGraph2;
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSingleSelection(boolean bl) {
        this.singleSelection = bl;
    }

    public boolean isSelected(Object object) {
        return object == null ? false : this.cells.contains(object);
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public int size() {
        return this.cells.size();
    }

    public void clear() {
        this.changeSelection(null, this.cells);
    }

    public Object getCell() {
        return this.cells.isEmpty() ? null : this.cells.iterator().next();
    }

    public Object[] getCells() {
        return this.cells.toArray();
    }

    public void setCell(Object object) {
        if (object != null) {
            this.setCells(new Object[]{object});
        } else {
            this.clear();
        }
    }

    public void setCells(Object[] objectArray) {
        if (objectArray != null) {
            if (this.singleSelection) {
                objectArray = new Object[]{this.getFirstSelectableCell(objectArray)};
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.graph.isCellSelectable(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            this.changeSelection(arrayList, this.cells);
        } else {
            this.clear();
        }
    }

    protected Object getFirstSelectableCell(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.graph.isCellSelectable(objectArray[i])) continue;
                return objectArray[i];
            }
        }
        return null;
    }

    public void addCell(Object object) {
        if (object != null) {
            this.addCells(new Object[]{object});
        }
    }

    public void addCells(Object[] objectArray) {
        if (objectArray != null) {
            Set<Object> set = null;
            if (this.singleSelection) {
                set = this.cells;
                objectArray = new Object[]{this.getFirstSelectableCell(objectArray)};
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.isSelected(objectArray[i]) || !this.graph.isCellSelectable(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            this.changeSelection(arrayList, set);
        }
    }

    public void removeCell(Object object) {
        if (object != null) {
            this.removeCells(new Object[]{object});
        }
    }

    public void removeCells(Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isSelected(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            this.changeSelection(null, arrayList);
        }
    }

    protected void changeSelection(Collection<Object> collection, Collection<Object> collection2) {
        if (collection != null && !collection.isEmpty() || collection2 != null && !collection2.isEmpty()) {
            mxSelectionChange mxSelectionChange2 = new mxSelectionChange(this, collection, collection2);
            mxSelectionChange2.execute();
            mxUndoableEdit mxUndoableEdit2 = new mxUndoableEdit(this, false);
            mxUndoableEdit2.add(mxSelectionChange2);
            this.fireEvent(new mxEventObject("undo", "edit", mxUndoableEdit2));
        }
    }

    protected void cellAdded(Object object) {
        if (object != null) {
            this.cells.add(object);
        }
    }

    protected void cellRemoved(Object object) {
        if (object != null) {
            this.cells.remove(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class mxSelectionChange
    implements mxUndoableEdit.mxUndoableChange {
        protected mxGraphSelectionModel model;
        protected Collection<Object> added;
        protected Collection<Object> removed;

        public mxSelectionChange(mxGraphSelectionModel mxGraphSelectionModel2, Collection<Object> collection, Collection<Object> collection2) {
            this.model = mxGraphSelectionModel2;
            this.added = collection != null ? new ArrayList<Object>(collection) : null;
            this.removed = collection2 != null ? new ArrayList<Object>(collection2) : null;
        }

        @Override
        public void execute() {
            Iterator<Object> iterator;
            if (this.removed != null) {
                iterator = this.removed.iterator();
                while (iterator.hasNext()) {
                    this.model.cellRemoved(iterator.next());
                }
            }
            if (this.added != null) {
                iterator = this.added.iterator();
                while (iterator.hasNext()) {
                    this.model.cellAdded(iterator.next());
                }
            }
            iterator = this.added;
            this.added = this.removed;
            this.removed = iterator;
            this.model.fireEvent(new mxEventObject("change", "added", this.added, "removed", this.removed));
        }
    }
}

