### R code from vignette source 'RMassBank.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: RMassBank.Rnw:24-26
###################################################
options(width=74)
#library(xtable)


###################################################
### code chunk number 2: RMassBank.Rnw:69-70
###################################################
library(RMassBank)


###################################################
### code chunk number 3: RMassBank.Rnw:76-77
###################################################
library(RMassBankData)


###################################################
### code chunk number 4: RMassBank.Rnw:129-131
###################################################
file.copy(system.file("list/NarcoticsDataset.csv", 
	package="RMassBankData"), "./Compoundlist.csv")


###################################################
### code chunk number 5: RMassBank.Rnw:140-141
###################################################
RmbSettingsTemplate("mysettings.ini")


###################################################
### code chunk number 6: RMassBank.Rnw:268-269
###################################################
loadRmbSettings("mysettings.ini")


###################################################
### code chunk number 7: RMassBank.Rnw:281-282
###################################################
w <- newMsmsWorkspace()


###################################################
### code chunk number 8: RMassBank.Rnw:288-293
###################################################
files <- list.files(system.file("spectra", package="RMassBankData"),
	 ".mzML", full.names = TRUE)
basename(files)
# To make the workflow faster here, we use only 2 compounds:
w@files <- files[1:2]


###################################################
### code chunk number 9: RMassBank.Rnw:301-302
###################################################
loadList("./Compoundlist.csv")


###################################################
### code chunk number 10: RMassBank.Rnw:347-349
###################################################
w <- msmsWorkflow(w, mode="pH", steps=c(1:4), archivename = 
				"pH_narcotics")


###################################################
### code chunk number 11: RMassBank.Rnw:354-355 (eval = FALSE)
###################################################
## plotRecalibration(w)


###################################################
### code chunk number 12: RMassBank.Rnw:364-368 (eval = FALSE)
###################################################
## 	w <- msmsWorkflow(w, mode="pH", steps=1)
## 	w <- msmsWorkflow(w, mode="pH", steps=2)
## 	w <- msmsWorkflow(w, mode="pH", steps=3)
## 	# etc.


###################################################
### code chunk number 13: RMassBank.Rnw:372-373 (eval = FALSE)
###################################################
## lapply(w@specs,function(s) s$foundOK)


###################################################
### code chunk number 14: RMassBank.Rnw:377-378 (eval = FALSE)
###################################################
## findProgress(w)


###################################################
### code chunk number 15: RMassBank.Rnw:386-391
###################################################
# In the really evaluated workflow, we do the following:
# we run steps 1 through 3, load the recalibration curve from a stored workflow
# and recalibrate the data using that curve.
storedW <- loadMsmsWorkspace(system.file("results/pH_narcotics_RF.RData", 
				package="RMassBankData"))


###################################################
### code chunk number 16: RMassBank.Rnw:397-406
###################################################
# Just to display the recalibration curve as calculated from
# the complete dataset:
storedW <- msmsWorkflow(storedW, mode="pH", steps=4)
# Copy the recalibration to workspace w and apply it
# (no graph displayed here)
w@rc <- storedW@rc
w@rc.ms1 <- storedW@rc.ms1
w <- msmsWorkflow(w, mode="pH", steps=4, archivename = 
	"pH_narcotics", newRecalibration = FALSE)


###################################################
### code chunk number 17: RMassBank.Rnw:411-413
###################################################
w <- msmsWorkflow(w, mode="pH", steps=c(5:8), archivename = 
		"pH_narcotics")


###################################################
### code chunk number 18: RMassBank.Rnw:418-419 (eval = FALSE)
###################################################
## archiveResults(w, filename)


###################################################
### code chunk number 19: RMassBank.Rnw:445-449
###################################################
mb <- newMbWorkspace(w)
mb <- resetInfolists(mb)
mb <- loadInfolists(mb, system.file("infolists_incomplete",
		package="RMassBankData"))


###################################################
### code chunk number 20: RMassBank.Rnw:453-455 (eval = FALSE)
###################################################
## mb <- resetInfolists(mb)
## mb <- loadInfolists(mb, my_folder_with_csv_infolists_inside)


###################################################
### code chunk number 21: RMassBank.Rnw:459-460 (eval = FALSE)
###################################################
## mb <- addPeaks(mb, my_corrected_Failpeaks.csv)


###################################################
### code chunk number 22: RMassBank.Rnw:465-466
###################################################
mb <- mbWorkflow(mb, infolist_path="./Narcotics_infolist.csv")


###################################################
### code chunk number 23: RMassBank.Rnw:487-489 (eval = FALSE)
###################################################
## mb <- resetInfolists(mb)
## mb <- loadInfolists(mb, my_folder_with_csv_infolists_inside)


###################################################
### code chunk number 24: RMassBank.Rnw:495-497
###################################################
mb <- resetInfolists(mb)
mb <- loadInfolists(mb, system.file("infolists", package="RMassBankData"))


###################################################
### code chunk number 25: RMassBank.Rnw:503-504
###################################################
mb <- mbWorkflow(mb)


###################################################
### code chunk number 26: RMassBank.Rnw:541-542
###################################################
sessionInfo()


