### R code from vignette source 'PAA_vignette.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: install (eval = FALSE)
###################################################
## # only if you install a Bioconductor package for the first time
## source("http://www.bioconductor.org/biocLite.R")
## # else
## library("BiocInstaller")
## biocLite("PAA", dependencies=TRUE)


###################################################
### code chunk number 3: start
###################################################
library(PAA)


###################################################
### code chunk number 4: targets
###################################################
targets <- read.table(file=list.files(system.file("extdata", package="PAA"),
 pattern = "^targets", full.names = TRUE), header=TRUE)
print(targets[1:3,])


###################################################
### code chunk number 5: loadGPR
###################################################
gpr <- system.file("extdata", package="PAA")
targets <- list.files(system.file("extdata", package="PAA"),
 pattern = "dummy_targets", full.names=TRUE)
dummy.elist <- loadGPR(gpr.path=gpr, targets.path=targets)
save(dummy.elist, file=paste(gpr, "/DummyData.RData",
   sep=""), compress="xz")


###################################################
### code chunk number 6: load
###################################################
cwd <- system.file(package="PAA")
dir.create(paste(cwd, "/demo/demo_output", sep=""))
output.path <- paste(cwd, "/demo/demo_output",  sep="")
load(paste(cwd, "/extdata/Alzheimer.RData", sep=""))


###################################################
### code chunk number 7: batchFilter
###################################################
lot1 <- elist$targets[elist$targets$Batch=='Batch1','ArrayID']
lot2 <- elist$targets[elist$targets$Batch=='Batch2','ArrayID']
elist <- batchFilter(elist=elist, lot1=lot1, lot2=lot2, p.thresh=0.001,
fold.thresh=3)


###################################################
### code chunk number 8: backgroundCorrect
###################################################
library(limma)
elist <- backgroundCorrect(elist, method="normexp",
 normexp.method="saddle")


###################################################
### code chunk number 9: plotNormMethods (eval = FALSE)
###################################################
## plotNormMethods(elist=elist)


###################################################
### code chunk number 10: plotMAPlots
###################################################
plotMAPlots(elist=elist, idx=10)


###################################################
### code chunk number 11: normalizeArrays
###################################################
elist <- normalizeArrays(elist=elist, method="cyclicloess",
cyclicloess.method="fast")


###################################################
### code chunk number 12: batchAdjust
###################################################
elist <- batchAdjust(elist=elist, log=TRUE)


###################################################
### code chunk number 13: unlog
###################################################
elist.unlog <- elist
elist.unlog$E <- 2^(elist$E)


###################################################
### code chunk number 14: volcanoPlot1
###################################################
c1 <- paste(rep("AD",20), 1:20, sep="")
c2 <- paste(rep("NDC",20), 1:20, sep="")
volcanoPlot(elist=elist.unlog, group1=c1, group2=c2, method="tTest",
p.thresh=0.01, fold.thresh=2)


###################################################
### code chunk number 15: volcanoPlot2 (eval = FALSE)
###################################################
## mMs.matrix1 <- mMs.matrix2 <- mMsMatrix(x=20, y=20)
## volcanoPlot(elist=elist.unlog, group1=c1, group2=c2, method="mMs",
## p.thresh=0.01, fold.thresh=2, mMs.matrix1=mMs.matrix1,
## mMs.matrix2=mMs.matrix2, above=1500, between=400)


###################################################
### code chunk number 16: pvaluePlot1
###################################################
pvaluePlot(elist=elist.unlog, group1=c1, group2=c2, method="tTest")


###################################################
### code chunk number 17: pvaluePlot2 (eval = FALSE)
###################################################
## mMs.matrix1 <- mMs.matrix2 <- mMsMatrix(x=20, y=20)
## pvaluePlot(elist=elist.unlog, group1=c1, group2=c2, method="mMs",
## mMs.matrix1=mMs.matrix1, mMs.matrix2=mMs.matrix2, above=1500,
## between=400)


###################################################
### code chunk number 18: pvaluePlot3
###################################################
pvaluePlot(elist=elist.unlog, group1=c1, group2=c2, method="tTest", adjust=TRUE)


###################################################
### code chunk number 19: pvaluePlot4 (eval = FALSE)
###################################################
## mMs.matrix1 <- mMs.matrix2 <- mMsMatrix(x=20, y=20)
## pvaluePlot(elist=elist.unlog, group1=c1, group2=c2, method="mMs",
## mMs.matrix1=mMs.matrix1, mMs.matrix2=mMs.matrix2, above=1500,
## between=400, adjust=TRUE)


###################################################
### code chunk number 20: diffAnalysis
###################################################
E <- elist.unlog$E
rownames(E) <- paste(elist.unlog$genes[,1], elist.unlog$genes[,3],
    elist.unlog$genes[,2])
write.table(x=cbind(rownames(E),E), file=paste(cwd,"/demo/demo_output/data.txt",
    sep=""), sep="\t", eol="\n", row.names=FALSE, quote=FALSE)
mMs.matrix1 <- mMs.matrix2 <- mMsMatrix(x=20, y=20)
diff.analysis.results <- diffAnalysis(input=E, label1=c1, label2=c2,
    class1="AD", class2="NDC", output.path=output.path,
    mMs.matrix1=mMs.matrix1, mMs.matrix2=mMs.matrix2, above=1500,
    between=400)
print(diff.analysis.results[1:10,])


###################################################
### code chunk number 21: preselect
###################################################
mMs.matrix1 <- mMs.matrix2 <- mMsMatrix(x=20, y=20)
pre.sel.results <- preselect(elist=elist.unlog, columns1=c1, columns2=c2,
    label1="AD", label2="NDC", discard.threshold=0.5, fold.thresh=1.5,
    discard.features=TRUE, mMs.above=1500, mMs.between=400,
    mMs.matrix1=mMs.matrix1, mMs.matrix2=mMs.matrix2,
    method="mMs")
elist <- elist[-pre.sel.results$discard,]


###################################################
### code chunk number 22: selectFeatures1 (eval = FALSE)
###################################################
## selectFeatures.results <- selectFeatures(elist,n1=20,n2=20,label1="AD",
##     label2="NDC",selection.method="rf.rfe",subruns=2,candidate.number=1000,
##     method="frequency")


###################################################
### code chunk number 23: selectFeatures2 (eval = FALSE)
###################################################
## selectFeatures.results <- selectFeatures(elist,n1=20,n2=20,label1="AD",
##     label2="NDC",selection.method="rf.rfe",subsamples=10,bootstraps=10,
##     method="ensemble")


###################################################
### code chunk number 24: loadSelectFeaturesResults
###################################################
# results of frequency-based feature selection:
load(paste(cwd, "/extdata/selectFeaturesResultsFreq.RData", sep=""))
# or results of ensemble feature selection:
load(paste(cwd, "/extdata/selectFeaturesResultsEns.RData", sep=""))


###################################################
### code chunk number 25: plotFeatures
###################################################
plotFeatures(features=selectFeatures.results$features, elist=elist, n1=20,
    n2=20, group1="AD", group2="NDC")


###################################################
### code chunk number 26: plotFeaturesHeatmap
###################################################
plotFeaturesHeatmap(features=selectFeatures.results$features, elist=elist,
    n1=20, n2=20, description=TRUE)


###################################################
### code chunk number 27: printFeatures
###################################################
printFeatures(features=selectFeatures.results$features, elist=elist.unlog)[,-2]


