### R code from vignette source 'Vignette.Rnw'

###################################################
### code chunk number 1: setup
###################################################
require(IdeoViz)
require(RColorBrewer) ### nice colours
data(binned_multiSeries)


###################################################
### code chunk number 2: example1
###################################################
ideo <- getIdeo("hg18")
head(ideo)
plotOnIdeo(chrom=seqlevels(binned_multiSeries), # which chrom to plot?
          ideoTable=ideo, # ideogram name
          values_GR=binned_multiSeries, # data goes here
          value_cols=colnames(mcols(binned_multiSeries)), # col to plot
          col=brewer.pal(n=5, 'Spectral'), # colours
          val_range=c(0,10), # set y-axis range
          ylab="array intensities",
          plot_title="Trendline example")  


###################################################
### code chunk number 3: example2
###################################################
data(binned_singleSeries)
data(hg18_ideo) # cytoBandIdeo table downloaded previously and stored as a data.frame.
plotOnIdeo(chrom=seqlevels(binned_singleSeries), 
          ideo=hg18_ideo,
          values_GR=binned_singleSeries, 
          value_cols=colnames(mcols(binned_singleSeries)),
          plotType='rect', # plot as bars
          col='blue', vertical=T,
          val_range=c(-1,1), ylab="dummy score",
          plot_title="Discretized example")


###################################################
### code chunk number 4: example3
###################################################
data(binned_fullGenome)
plotOnIdeo(chrom=seqlevels(binned_fullGenome), 
          ideo=ideo, 
          values_GR=binned_fullGenome, 
          value_cols=colnames(mcols(binned_fullGenome)),
          plotType='rect',
          col='orange', addScale=F, # hide scale to remove visual clutter
          plot_title="Whole genome view",
          val_range=c(-1,1),cex.axis=0.5,chromName_cex=0.6)


###################################################
### code chunk number 5: example4
###################################################
ideo_hg19 <- getIdeo("hg19")
chroms <- c("chr1","chr2","chrX")
data(GSM733664_broadPeaks)
head(GSM733664_broadPeaks)

chrom_bins <- getBins(chroms, ideo_hg19,stepSize=5*100*1000)
avg_peak <- avgByBin(data.frame(value=GSM733664_broadPeaks[,7]), 
  GSM733664_broadPeaks[,1:3], chrom_bins)

plotOnIdeo(chrom=seqlevels(chrom_bins), 
          ideoTable=ideo_hg19, 
          values_GR=avg_peak, value_cols='value', 
          val_range=c(0,50), 
          plotType='rect', 
          col='blue', vertical=T
) 



###################################################
### code chunk number 6: Vignette.Rnw:101-102
###################################################
sessionInfo()


