## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy         = FALSE, 
               out.truncate = 80,
               out.lines    = 6,
               dev          = 'pdf',
               include      = TRUE,
               fig.width    = 6,
               fig.height   = 6,
               resolution   = 100,
               message      = FALSE)

## ----style-Sweave, eval=TRUE, echo=FALSE, results="asis"--------------------------------
BiocStyle::latex()

## ----loadPKG, echo=FALSE----------------------------------------------------------------
library(org.Hs.eg.db)
library(GO.db)
library(GOSemSim)

## ----options,results='hide',echo=FALSE----------------------------------------
options(digits=3, width=80, prompt=" ", continue=" ")

## ----loading, eval=FALSE, results='hide'--------------------------------------
#  library(GOSemSim)
#  help(GOSemSim)

## ----mgoSim-------------------------------------------------------------------
goSim("GO:0004022", "GO:0005515", ont="MF", measure="Wang")
go1 = c("GO:0004022","GO:0004024","GO:0004174")
go2 = c("GO:0009055","GO:0005515")
mgoSim(go1, go2, ont="MF", measure="Wang", combine=NULL)
mgoSim(go1, go2, ont="MF", measure="Wang", combine="BMA")

## ----mgeneSim-----------------------------------------------------------------
geneSim("241", "251", ont="MF", organism="human", measure="Wang", combine="BMA")
mgeneSim(genes=c("835", "5261","241", "994"), 
			ont="MF", organism="human", measure="Wang", 
			verbose=FALSE)

## ----clusterSim, eval=FALSE---------------------------------------------------
#  gs1 <- c("835", "5261","241", "994", "514", "533")
#  gs2 <- c("578","582", "400", "409", "411")
#  clusterSim(gs1, gs2, ont="MF", organism="human", measure="Wang", combine="BMA")
#  
#  x <- org.Hs.egGO
#  hsEG <- mappedkeys(x)
#  set.seed <- 123
#  clusters <- list(a=sample(hsEG, 20), b=sample(hsEG, 20), c=sample(hsEG, 20))
#  mclusterSim(clusters, ont="MF", organism="human", measure="Wang", combine="BMA")

## ----sessInfo, results='asis', echo=FALSE-------------------------------------
toLatex(sessionInfo())

