## ----, eval=FALSE--------------------------------------------------------
#  geno <- MatrixGenotypeReader(genotype = genotype, snpID = snpID, chromosome = chromosome,
#                               position = position, scanID = scanID)
#  genoData <- GenotypeData(geno)

## ----, eval=FALSE--------------------------------------------------------
#  geno <- GdsGenotypeReader(filename = "genotype.gds")
#  genoData <- GenotypeData(geno)

## ----, eval=FALSE--------------------------------------------------------
#  snpgdsBED2GDS(bed.fn = "genotype.bed", bim.fn = "genotype.bim", fam.fn = "genotype.fam",
#                out.gdsfn = "genotype.gds")

## ----, echo=FALSE, message=FALSE-----------------------------------------
library(GENESIS)

## ------------------------------------------------------------------------
# read in GDS data
gdsfile <- system.file("extdata", "HapMap_ASW_MXL_geno.gds", package="GENESIS")
HapMap_geno <- GdsGenotypeReader(filename = gdsfile)
# create a GenotypeData class object
HapMap_genoData <- GenotypeData(HapMap_geno)
HapMap_genoData

## ------------------------------------------------------------------------
# read individual IDs from GenotypeData object
iids <- getScanID(HapMap_genoData)
head(iids)
# create matrix of KING estimates
KINGmat <- king2mat(file.kin0 = system.file("extdata", "MXL_ASW.kin0", package="GENESIS"), 
    				file.kin = system.file("extdata", "MXL_ASW.kin", package="GENESIS"), 
					iids = iids)
KINGmat[1:6,1:6]

## ------------------------------------------------------------------------
# run PC-AiR
mypcair <- pcair(genoData = HapMap_genoData, kinMat = KINGmat, divMat = KINGmat)

## ----, eval=FALSE--------------------------------------------------------
#  mypcair <- pcair(genoData = HapMap_genoData, unrel.set = IDs)

## ----, eval=FALSE--------------------------------------------------------
#  mypcair <- pcair(genoData = HapMap_genoData, kinMat = KINGmat, divMat = KINGmat, unrel.set = IDs)

## ------------------------------------------------------------------------
part <- pcairPartition(kinMat = KINGmat, divMat = KINGmat)

## ------------------------------------------------------------------------
head(part$unrels); head(part$rels)

## ------------------------------------------------------------------------
summary(mypcair)

## ----, fig.show='hold', fig.width=3.4, fig.height=3.4, dev.args=list(pointsize = 10, bg='white')----
# plot top 2 PCs
plot(mypcair)
# plot PCs 3 and 4
plot(mypcair, vx = 3, vy = 4)

