## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ------------------------------------------------------------------------
library(BubbleTree)
data(hetero.gr) #loads sequence variants
data(cnv.gr) #loads copy number variation data

## ------------------------------------------------------------------------
rbd=getRBD(hetero.gr,cnv.gr)

## ------------------------------------------------------------------------
plotBubbles(rbd)

## ----, eval=FALSE--------------------------------------------------------
#  library(VariantAnnotation)
#  vc=readVcf("MyN_TSamples.vcf",genome="hg19")
#  fq=geno(vc)$FREQ
#  freq <- data.frame(fq)
#  freq[,] <- as.numeric(gsub("%", "", as.matrix(freq[,])))/100
#  colnames(freq)=paste(colnames(freq),"freq",sep=".")

## ----, eval=FALSE--------------------------------------------------------
#  dp=geno(vc)$DP
#  colnames(dp)=paste(colnames(dp),"dp",sep=".")
#  #combine all with chr and position info
#  snp.dat=data.frame("CHROM"=as.vector(seqnames(vc)),
#                     "POS"=start(vc),freq,dp)
#  

## ----, eval=FALSE--------------------------------------------------------
#  is.hetero <- function(x, a=0.4, b=0.6) {
#    (x - a)  *  (b - x) >= 0
#  }
#  
#  snp.ss=subset(snp.dat, ! CHROM %in% c("chrX", "chrY") & normal.dp >= 15 &  is.hetero(normal.freq, 0.4, 0.6))

## ----, eval=FALSE--------------------------------------------------------
#  library(GRanges)
#  snp.gr <- GRanges(snp.ss$CHROM, IRanges(snp.ss$POS, snp.ss$POS), mcols=snp.ss[,"tumor.freq"])
#  names(elementMetadata(snp.gr))[grep(".freq",names(elementMetadata(snp.gr)))]<-"freq"

## ----, eval=FALSE--------------------------------------------------------
#  library(DNAcopy)
#  #create a CNA object
#  CNA.object <- CNA(demo.eCNV$logR, demo.eCNV$chr,
#                    demo.eCNV$probe_end, data.type = "logratio", sampleid = "test")
#  #smooth
#  smoothed.CNA.object <- smooth.CNA(CNA.object)
#  #segment
#  seg=segment(smoothed.CNA.object)

## ----, eval=FALSE--------------------------------------------------------
#  library(GenomicRanges)
#  min.num <- 10
#  cnv.gr <- with(subset(seg$output, num.mark >= min.num & ! chrom %in% c("chrX", "chrY")) , GRanges(chrom, IRanges(loc.start, loc.end), mcols=cbind(num.mark, seg.mean)))
#  

## ------------------------------------------------------------------------
library(BubbleTree)
data(hetero.gr) 
data(cnv.gr)
rbd=getRBD(snp.gr=hetero.gr,cnv.gr=cnv.gr)
head(rbd)

## ------------------------------------------------------------------------
drawBranches()

## ------------------------------------------------------------------------
plotBubbles(rbd)

## ------------------------------------------------------------------------
pur <- calc.prev(rbdx=rbd,heurx=FALSE,modex=3,plotx="prev_model.pdf")
# extract the genotype (branch) and frequency for each segment
 head(pur[[1]]$ploidy_prev)
# tumor purity
 pur[[2]][nrow(pur[[2]]),2]

## ----drawBubble_example--------------------------------------------------
drawBranches(main="Demo")
drawBubble(0.5, 0.3, 5000, "blue", info="PTEN", size=2, adj=-0.5)

## ----compareBubbles_example----------------------------------------------
data(hcc.rbd.lst)

## ------------------------------------------------------------------------
with(hcc.rbd.lst, compareBubbles(HCC11.Primary.Tumor, HCC11.Recurrent.Tumor, min.dist=0.05, min.mark=2000))

## ------------------------------------------------------------------------
with(hcc.rbd.lst, compareBubbles(HCC4.Recurrent.Tumor, HCC11.Recurrent.Tumor, min.dist=0.0, max.dist=0.1, min.mark=500))

