/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.Xref;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.bio.Organism;
import org.junit.Assert;
import org.junit.Before;

public class Test {
    boolean eventReceived = false;

    @Before
    public void setUp() {
        BioDataSource.init();
    }

    @org.junit.Test
    public void testInit() {
        for (DataSource ds : DataSource.getDataSources()) {
            Assert.assertNotNull((Object)ds);
            Assert.assertNotNull((Object)ds.getFullName());
            Assert.assertNotNull((Object)ds.getSystemCode());
        }
    }

    @org.junit.Test
    public void testURN() {
        Xref ref = new Xref("3643", BioDataSource.ENTREZ_GENE);
        Xref ref2 = new Xref("GO:00001", BioDataSource.GENE_ONTOLOGY);
        Assert.assertEquals((Object)"urn:miriam:ncbigene:3643", (Object)ref.getURN());
        Assert.assertEquals((Object)"urn:miriam:obo.go:GO%3A00001", (Object)ref2.getURN());
    }

    @org.junit.Test
    public void testSpeciesSpecificEnsembl() {
        Assert.assertEquals((Object)BioDataSource.ENSEMBL_COW, (Object)BioDataSource.getSpeciesSpecificEnsembl(Organism.BosTaurus));
        Assert.assertEquals((Object)BioDataSource.ENSEMBL_MOSQUITO, (Object)BioDataSource.getSpeciesSpecificEnsembl(Organism.AnophelesGambiae));
    }

    @org.junit.Test
    public void testBioDataSources() {
        Assert.assertEquals((Object)BioDataSource.WORMBASE.getOrganism(), (Object)((Object)Organism.CaenorhabditisElegans));
        Assert.assertEquals((Object)BioDataSource.ENSEMBL_CHICKEN.getOrganism(), (Object)((Object)Organism.GallusGallus));
        Assert.assertEquals((Object)BioDataSource.CAS.getType(), (Object)"metabolite");
    }

    @org.junit.Test
    public void testPatterns() {
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("1.1.1.1").contains(BioDataSource.ENZYME_CODE));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("50-99-7").contains(BioDataSource.CAS));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("HMDB00122").contains(BioDataSource.HMDB));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("C00031").contains(BioDataSource.KEGG_COMPOUND));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("CHEBI:17925").contains(BioDataSource.CHEBI));
    }

    @org.junit.Test
    public void testBasCASNumbers() {
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("50-99-77").contains(BioDataSource.CAS));
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("1-99-77").contains(BioDataSource.CAS));
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("50-1-7").contains(BioDataSource.CAS));
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("50-333-7").contains(BioDataSource.CAS));
    }

    @org.junit.Test
    public void testDataSource() {
        DataSource ds = BioDataSource.ENSEMBL;
        Assert.assertEquals((Object)ds.getFullName(), (Object)"Ensembl");
        Assert.assertEquals((Object)ds.getSystemCode(), (Object)"En");
        DataSource ds4 = DataSource.getBySystemCode("En");
        Assert.assertEquals((Object)ds, (Object)ds4);
        DataSource ds5 = DataSource.getByFullName("Entrez Gene");
        Assert.assertEquals((Object)ds5, (Object)BioDataSource.ENTREZ_GENE);
    }

    @org.junit.Test
    public void testDataSourceFilter() {
        Set<DataSource> f1 = DataSource.getFilteredSet(true, null, null);
        Assert.assertTrue((boolean)f1.contains(BioDataSource.ENSEMBL_HUMAN));
        Assert.assertTrue((boolean)f1.contains(BioDataSource.HMDB));
        Assert.assertFalse((boolean)f1.contains(BioDataSource.AFFY));
        Set<DataSource> f2 = DataSource.getFilteredSet(null, null, (Object)Organism.CaenorhabditisElegans);
        Assert.assertTrue((boolean)f2.contains(BioDataSource.ENSEMBL_CELEGANS));
        Assert.assertTrue((boolean)f2.contains(BioDataSource.WORMBASE));
        Assert.assertFalse((boolean)f2.contains(BioDataSource.ZFIN));
        Set<DataSource> f3 = DataSource.getFilteredSet(null, true, null);
        Assert.assertTrue((boolean)f3.contains(BioDataSource.HMDB));
        Assert.assertFalse((boolean)f3.contains(BioDataSource.WORMBASE));
        Assert.assertFalse((boolean)f3.contains(BioDataSource.ENSEMBL_HUMAN));
        Set<DataSource> f4 = DataSource.getFilteredSet(null, false, null);
        Assert.assertTrue((boolean)f4.contains(BioDataSource.ENSEMBL_HUMAN));
        Assert.assertTrue((boolean)f4.contains(BioDataSource.WORMBASE));
        Assert.assertFalse((boolean)f4.contains(BioDataSource.HMDB));
    }

    @org.junit.Test
    public void testAlias() {
        DataSource ds = DataSource.getByAlias("ensembl_gene_id");
        Assert.assertSame((Object)ds, (Object)BioDataSource.ENSEMBL);
    }

    @org.junit.Test
    public void testFromUrn() {
        Xref ref = Xref.fromUrn("urn:miriam:ncbigene:3643");
        Assert.assertEquals((Object)BioDataSource.ENTREZ_GENE, (Object)ref.getDataSource());
        Assert.assertEquals((Object)"3643", (Object)ref.getId());
        ref = Xref.fromUrn("urn:miriam:blahblahblah:abc");
        Assert.assertEquals((Object)DataSource.getByFullName("blahblahblah"), (Object)ref.getDataSource());
        ref = Xref.fromUrn("blahblahblha");
        Assert.assertNull((Object)ref);
        ref = Xref.fromUrn("urn:miriam:obo.go:GO%3A00001234");
        Assert.assertEquals((Object)BioDataSource.GENE_ONTOLOGY, (Object)ref.getDataSource());
        Assert.assertEquals((Object)"GO:00001234", (Object)ref.getId());
    }
}

