/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class Discretize
extends PotentialClassIgnorer
implements UnsupervisedFilter,
OptionHandler,
WeightedInstancesHandler {
    protected Range m_DiscretizeCols = new Range();
    protected int m_NumBins = 10;
    protected double m_DesiredWeightOfInstancesPerInterval = -1.0;
    protected double[][] m_CutPoints = null;
    protected boolean m_MakeBinary = false;
    protected boolean m_FindNumBins = false;
    protected boolean m_UseEqualFrequency = false;
    protected String m_DefaultCols;

    public Discretize() {
        this.m_DefaultCols = "first-last";
        this.setAttributeIndices("first-last");
    }

    public Discretize(String string) {
        this.m_DefaultCols = string;
        this.setAttributeIndices(string);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option("\tSpecifies the (maximum) number of bins to divide numeric attributes into.\n\t(default = 10)", "B", 1, "-B <num>"));
        vector.addElement(new Option("\tSpecifies the desired weight of instances per bin for\n\tequal-frequency binning. If this is set to a positive\n\tnumber then the -B option will be ignored.\n\t(default = -1)", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tUse equal-frequency instead of equal-width discretization.", "F", 0, "-F"));
        vector.addElement(new Option("\tOptimize number of bins using leave-one-out estimate\n\tof estimated entropy (for equal-width discretization).\n\tIf this is set then the -B option will be ignored.", "O", 0, "-O"));
        vector.addElement(new Option("\tSpecifies list of columns to Discretize. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        vector.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        vector.addElement(new Option("\tOutput binary attributes for discretized attributes.", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setMakeBinary(Utils.getFlag('D', stringArray));
        this.setUseEqualFrequency(Utils.getFlag('F', stringArray));
        this.setFindNumBins(Utils.getFlag('O', stringArray));
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setDesiredWeightOfInstancesPerInterval(new Double(string));
        } else {
            this.setDesiredWeightOfInstancesPerInterval(-1.0);
        }
        String string2 = Utils.getOption('B', stringArray);
        if (string2.length() != 0) {
            this.setBins(Integer.parseInt(string2));
        } else {
            this.setBins(10);
        }
        String string3 = Utils.getOption('R', stringArray);
        if (string3.length() != 0) {
            this.setAttributeIndices(string3);
        } else {
            this.setAttributeIndices(this.m_DefaultCols);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        if (this.getMakeBinary()) {
            stringArray[n++] = "-D";
        }
        if (this.getUseEqualFrequency()) {
            stringArray[n++] = "-F";
        }
        if (this.getFindNumBins()) {
            stringArray[n++] = "-O";
        }
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getBins();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getDesiredWeightOfInstancesPerInterval();
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        if (this.m_MakeBinary && this.m_IgnoreClass) {
            throw new IllegalArgumentException("Can't ignore class when changing the number of attributes!");
        }
        super.setInputFormat(instances);
        this.m_DiscretizeCols.setUpper(instances.numAttributes() - 1);
        this.m_CutPoints = null;
        if (this.getFindNumBins() && this.getUseEqualFrequency()) {
            throw new IllegalArgumentException("Bin number optimization in conjunction with equal-frequency binning not implemented.");
        }
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_CutPoints != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_CutPoints == null) {
            this.calculateCutPoints();
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public String globalInfo() {
        return "An instance filter that discretizes a range of numeric attributes in the dataset into nominal attributes. Discretization is by simple binning. Skips the class attribute if set.";
    }

    public String findNumBinsTipText() {
        return "Optimize number of equal-width bins using leave-one-out. Doesn't work for equal-frequency binning";
    }

    public boolean getFindNumBins() {
        return this.m_FindNumBins;
    }

    public void setFindNumBins(boolean bl) {
        this.m_FindNumBins = bl;
    }

    public String makeBinaryTipText() {
        return "Make resulting attributes binary.";
    }

    public boolean getMakeBinary() {
        return this.m_MakeBinary;
    }

    public void setMakeBinary(boolean bl) {
        this.m_MakeBinary = bl;
    }

    public String desiredWeightOfInstancesPerIntervalTipText() {
        return "Sets the desired weight of instances per interval for equal-frequency binning.";
    }

    public double getDesiredWeightOfInstancesPerInterval() {
        return this.m_DesiredWeightOfInstancesPerInterval;
    }

    public void setDesiredWeightOfInstancesPerInterval(double d) {
        this.m_DesiredWeightOfInstancesPerInterval = d;
    }

    public String useEqualFrequencyTipText() {
        return "If set to true, equal-frequency binning will be used instead of equal-width binning.";
    }

    public boolean getUseEqualFrequency() {
        return this.m_UseEqualFrequency;
    }

    public void setUseEqualFrequency(boolean bl) {
        this.m_UseEqualFrequency = bl;
    }

    public String binsTipText() {
        return "Number of bins.";
    }

    public int getBins() {
        return this.m_NumBins;
    }

    public void setBins(int n) {
        this.m_NumBins = n;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected (numeric) attributes in the range will be discretized; if true, only non-selected attributes will be discretized.";
    }

    public boolean getInvertSelection() {
        return this.m_DiscretizeCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_DiscretizeCols.setInvert(bl);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_DiscretizeCols.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_DiscretizeCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public double[] getCutPoints(int n) {
        if (this.m_CutPoints == null) {
            return null;
        }
        return this.m_CutPoints[n];
    }

    protected void calculateCutPoints() {
        Object var1_1 = null;
        this.m_CutPoints = new double[this.getInputFormat().numAttributes()][];
        for (int i = this.getInputFormat().numAttributes() - 1; i >= 0; --i) {
            if (!this.m_DiscretizeCols.isInRange(i) || !this.getInputFormat().attribute(i).isNumeric() || this.getInputFormat().classIndex() == i) continue;
            if (this.m_FindNumBins) {
                this.findNumBins(i);
                continue;
            }
            if (!this.m_UseEqualFrequency) {
                this.calculateCutPointsByEqualWidthBinning(i);
                continue;
            }
            this.calculateCutPointsByEqualFrequencyBinning(i);
        }
    }

    protected void calculateCutPointsByEqualWidthBinning(int n) {
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
            Instance instance = this.getInputFormat().instance(i);
            if (instance.isMissing(n)) continue;
            double d3 = instance.value(n);
            if (d < d2) {
                d = d2 = d3;
            }
            if (d3 > d) {
                d = d3;
            }
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        double d4 = (d - d2) / (double)this.m_NumBins;
        double[] dArray = null;
        if (this.m_NumBins > 1 && d4 > 0.0) {
            dArray = new double[this.m_NumBins - 1];
            for (int i = 1; i < this.m_NumBins; ++i) {
                dArray[i - 1] = d2 + d4 * (double)i;
            }
        }
        this.m_CutPoints[n] = dArray;
    }

    protected void calculateCutPointsByEqualFrequencyBinning(int n) {
        double d;
        Instances instances = new Instances(this.getInputFormat());
        instances.sort(n);
        double d2 = 0.0;
        for (int i = 0; i < instances.numInstances() && !instances.instance(i).isMissing(n); ++i) {
            d2 += instances.instance(i).weight();
        }
        double[] dArray = new double[this.m_NumBins - 1];
        if (this.getDesiredWeightOfInstancesPerInterval() > 0.0) {
            d = this.getDesiredWeightOfInstancesPerInterval();
            dArray = new double[(int)(d2 / d)];
        } else {
            d = d2 / (double)this.m_NumBins;
            dArray = new double[this.m_NumBins - 1];
        }
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < instances.numInstances() - 1 && !instances.instance(i).isMissing(n); ++i) {
            d3 += instances.instance(i).weight();
            d2 -= instances.instance(i).weight();
            if (!(instances.instance(i).value(n) < instances.instance(i + 1).value(n))) continue;
            if (d3 >= d) {
                if (d - d4 < d3 - d && n3 != -1) {
                    dArray[n2] = (instances.instance(n3).value(n) + instances.instance(n3 + 1).value(n)) / 2.0;
                    d4 = d3 -= d4;
                    n3 = i;
                } else {
                    dArray[n2] = (instances.instance(i).value(n) + instances.instance(i + 1).value(n)) / 2.0;
                    d3 = 0.0;
                    d4 = 0.0;
                    n3 = -1;
                }
                d = (d2 + d3) / (double)(dArray.length + 1 - ++n2);
                continue;
            }
            n3 = i;
            d4 = d3;
        }
        if (n2 < dArray.length && n3 != -1) {
            dArray[n2] = (instances.instance(n3).value(n) + instances.instance(n3 + 1).value(n)) / 2.0;
            ++n2;
        }
        if (n2 == 0) {
            this.m_CutPoints[n] = null;
        } else {
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = dArray[i];
            }
            this.m_CutPoints[n] = dArray2;
        }
    }

    protected void findNumBins(int n) {
        int n2;
        Instance instance;
        int n3;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        int n4 = 1;
        for (n3 = 0; n3 < this.getInputFormat().numInstances(); ++n3) {
            instance = this.getInputFormat().instance(n3);
            if (instance.isMissing(n)) continue;
            double d5 = instance.value(n);
            if (d5 > d2) {
                d2 = d5;
            }
            if (!(d5 < d)) continue;
            d = d5;
        }
        for (n3 = 0; n3 < this.m_NumBins; ++n3) {
            double[] dArray = new double[n3 + 1];
            d3 = (d2 - d) / (double)(n3 + 1);
            block2: for (n2 = 0; n2 < this.getInputFormat().numInstances(); ++n2) {
                instance = this.getInputFormat().instance(n2);
                if (instance.isMissing(n)) continue;
                for (int i = 0; i < n3 + 1; ++i) {
                    if (!(instance.value(n) <= d + ((double)i + 1.0) * d3)) continue;
                    int n5 = i;
                    dArray[n5] = dArray[n5] + instance.weight();
                    continue block2;
                }
            }
            double d6 = 0.0;
            for (n2 = 0; n2 < n3 + 1; ++n2) {
                if (dArray[n2] < 2.0) {
                    d6 = Double.MAX_VALUE;
                    break;
                }
                d6 -= dArray[n2] * Math.log((dArray[n2] - 1.0) / d3);
            }
            if (!(d6 < d4)) continue;
            d4 = d6;
            n4 = n3 + 1;
        }
        double[] dArray = null;
        if (n4 > 1 && d3 > 0.0) {
            dArray = new double[n4 - 1];
            for (n2 = 1; n2 < n4; ++n2) {
                dArray[n2 - 1] = d + d3 * (double)n2;
            }
        }
        this.m_CutPoints[n] = dArray;
    }

    protected void setOutputFormat() {
        if (this.m_CutPoints == null) {
            this.setOutputFormat(null);
            return;
        }
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        int n = this.getInputFormat().classIndex();
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            if (this.m_DiscretizeCols.isInRange(i) && this.getInputFormat().attribute(i).isNumeric() && this.getInputFormat().classIndex() != i) {
                if (!this.m_MakeBinary) {
                    FastVector fastVector2 = new FastVector(1);
                    if (this.m_CutPoints[i] == null) {
                        fastVector2.addElement("'All'");
                    } else {
                        for (int j = 0; j <= this.m_CutPoints[i].length; ++j) {
                            if (j == 0) {
                                fastVector2.addElement("'(-inf-" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "]'");
                                continue;
                            }
                            if (j == this.m_CutPoints[i].length) {
                                fastVector2.addElement("'(" + Utils.doubleToString(this.m_CutPoints[i][j - 1], 6) + "-inf)'");
                                continue;
                            }
                            fastVector2.addElement("'(" + Utils.doubleToString(this.m_CutPoints[i][j - 1], 6) + "-" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "]'");
                        }
                    }
                    fastVector.addElement(new Attribute(this.getInputFormat().attribute(i).name(), fastVector2));
                    continue;
                }
                if (this.m_CutPoints[i] == null) {
                    FastVector fastVector3 = new FastVector(1);
                    fastVector3.addElement("'All'");
                    fastVector.addElement(new Attribute(this.getInputFormat().attribute(i).name(), fastVector3));
                    continue;
                }
                if (i < this.getInputFormat().classIndex()) {
                    n += this.m_CutPoints[i].length - 1;
                }
                for (int j = 0; j < this.m_CutPoints[i].length; ++j) {
                    FastVector fastVector4 = new FastVector(2);
                    fastVector4.addElement("'(-inf-" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "]'");
                    fastVector4.addElement("'(" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "-inf)'");
                    fastVector.addElement(new Attribute(this.getInputFormat().attribute(i).name(), fastVector4));
                }
                continue;
            }
            fastVector.addElement(this.getInputFormat().attribute(i).copy());
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(n);
        this.setOutputFormat(instances);
    }

    protected void convertInstance(Instance instance) {
        int n = 0;
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            if (this.m_DiscretizeCols.isInRange(i) && this.getInputFormat().attribute(i).isNumeric() && this.getInputFormat().classIndex() != i) {
                int n2;
                double d = instance.value(i);
                if (this.m_CutPoints[i] == null) {
                    dArray[n] = instance.isMissing(i) ? Instance.missingValue() : 0.0;
                    ++n;
                    continue;
                }
                if (!this.m_MakeBinary) {
                    if (instance.isMissing(i)) {
                        dArray[n] = Instance.missingValue();
                    } else {
                        for (n2 = 0; n2 < this.m_CutPoints[i].length && !(d <= this.m_CutPoints[i][n2]); ++n2) {
                        }
                        dArray[n] = n2;
                    }
                    ++n;
                    continue;
                }
                for (n2 = 0; n2 < this.m_CutPoints[i].length; ++n2) {
                    dArray[n] = instance.isMissing(i) ? Instance.missingValue() : (d <= this.m_CutPoints[i][n2] ? 0.0 : 1.0);
                    ++n;
                }
                continue;
            }
            dArray[n] = instance.value(i);
            ++n;
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Discretize(), stringArray);
            } else {
                Filter.filterFile(new Discretize(), stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

