
\name{xlaevis_dbconn}

\alias{xlaevis_dbconn}
\alias{xlaevis_dbfile}
\alias{xlaevis_dbschema}
\alias{xlaevis_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  xlaevis_dbconn()
  xlaevis_dbfile()
  xlaevis_dbschema(file="", show.indices=FALSE)
  xlaevis_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{xlaevis_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{xlaevis_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{xlaevis_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{xlaevis_dbschema} prints the schema definition of the
  package annotation DB.

  \code{xlaevis_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{xlaevis_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{xlaevis_dbfile}: a character string with the path to the
  package annotation DB.

  \code{xlaevis_dbschema}: none (invisible \code{NULL}).

  \code{xlaevis_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(xlaevis_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by xlaevis_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=xlaevis_dbfile(), cache_size=64000,
  synchronous=0)

  xlaevis_dbschema()

  xlaevis_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

