\name{reactomePATHID2NAME}
\alias{reactomePATHID2NAME}
\title{An annotation data object that maps Reactome pathway identifiers to
  Reactome pathway names}
\description{
   reactomePATHID2NAME maps Reactome pathway identifiers to pathway names used by
   Reactome for various pathways 
}
\details{
  This is an R object containing key and value pairs. Keys are
  Reactome pathway identifiers and values are pathway names. Values are vectors of
  length 1.  

  Mappings were based on data provided by: Reactome 
  http://www.reactome.org/download/current/sql.gz & http://www.reactome.org/download/current/sql_dn.gz
  With a date stamp from the source of: 2010-Dec-21

}
\references{
\url{http://www.reactome.org/}
}
\examples{
	xx <- as.list(reactomePATHID2NAME)
	if(length(xx) > 0){
		# get the value for the first key
		xx[[1]]
		# Get the values for a few keys
		if(length(xx) >= 3){
			xx[1:3]
		}
	}
}
\keyword{datasets}

