\name{reactomeEXTID2PATHID}
\alias{reactomeEXTID2PATHID}
\title{An annotation data object that maps Entrez Gene identifiers to Reactome pathway identifiers}
\description{
  reactomeEXTID2PATHID maps Entrez Gene identifiers to Reactome pathway identifiers.   
}
\details{
  This is an R object containing key and value pairs. Keys are
  Entrez Gene identifiers and values are the corresponding Reactome pathway identifiers. Values are
  vectors of length 1 or greater depending on whether a given external
  identifier can be mapped to only one or more Reactome pathway identifiers.

  Reactome pathway identifiers are the identifiers used by Reactome for various
  pathways.

  Mappings between Reactome pathway identifiers and pathway names can be obtained
  through another annotation data object named reactomePATHID2NAME. 

  Mappings were based on data provided by: Reactome 
  http://www.reactome.org/download/current/sql.gz & http://www.reactome.org/download/current/sql_dn.gz
  With a date stamp from the source of: 2010-Dec-21

}
\references{
\url{http://www.reactome.org/}
}
\examples{
	xx <- as.list(reactomeEXTID2PATHID)
	if(length(xx) > 0){
		# Get the value of the first key
		xx[[1]]
		# Get the values for multiget for a few keys
		if(length(xx) >= 3){
			xx[1:3]
		}
	}
}
\keyword{datasets}

