datacache <- new.env(hash=TRUE, parent=emptyenv())

mu11ksubb <- function() showQCData("mu11ksubb", datacache)
mu11ksubb_dbconn <- function() dbconn(datacache)
mu11ksubb_dbfile <- function() dbfile(datacache)
mu11ksubb_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mu11ksubb_dbInfo <- function() dbInfo(datacache)

mu11ksubbORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mu11ksubb.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mu11ksubb", "chip mu11ksubb", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mu11ksubb.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mu11ksubb_dbconn())
}

