
\name{hu6800_dbconn}

\alias{hu6800_dbconn}
\alias{hu6800_dbfile}
\alias{hu6800_dbschema}
\alias{hu6800_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hu6800_dbconn()
  hu6800_dbfile()
  hu6800_dbschema(file="", show.indices=FALSE)
  hu6800_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hu6800_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hu6800_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hu6800_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hu6800_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hu6800_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hu6800_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hu6800_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hu6800_dbschema}: none (invisible \code{NULL}).

  \code{hu6800_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hu6800_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by hu6800_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hu6800_dbfile(), cache_size=64000,
  synchronous=0)

  hu6800_dbschema()

  hu6800_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

