
\name{hu35ksubc_dbconn}

\alias{hu35ksubc_dbconn}
\alias{hu35ksubc_dbfile}
\alias{hu35ksubc_dbschema}
\alias{hu35ksubc_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hu35ksubc_dbconn()
  hu35ksubc_dbfile()
  hu35ksubc_dbschema(file="", show.indices=FALSE)
  hu35ksubc_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hu35ksubc_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hu35ksubc_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hu35ksubc_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hu35ksubc_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hu35ksubc_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hu35ksubc_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hu35ksubc_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hu35ksubc_dbschema}: none (invisible \code{NULL}).

  \code{hu35ksubc_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hu35ksubc_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by hu35ksubc_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hu35ksubc_dbfile(), cache_size=64000,
  synchronous=0)

  hu35ksubc_dbschema()

  hu35ksubc_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

