datacache <- new.env(hash=TRUE, parent=emptyenv())

hu35ksubc <- function() showQCData("hu35ksubc", datacache)
hu35ksubc_dbconn <- function() dbconn(datacache)
hu35ksubc_dbfile <- function() dbfile(datacache)
hu35ksubc_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hu35ksubc_dbInfo <- function() dbInfo(datacache)

hu35ksubcORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hu35ksubc.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hu35ksubc", "chip hu35ksubc", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hu35ksubc.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hu35ksubc_dbconn())
}

