datacache <- new.env(hash=TRUE, parent=emptyenv())

hom.Mm.inp <- function() showQCData("hom.Mm.inp", datacache)
hom.Mm.inp_dbconn <- function() dbconn(datacache)
hom.Mm.inp_dbfile <- function() dbfile(datacache)
hom.Mm.inp_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hom.Mm.inp_dbInfo <- function() dbInfo(datacache)

hom.Mm.inpORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hom.Mm.inp.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"InparanoidDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)

    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("INPARANOID_DB", "hom.Mm.inp", "Mouse", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hom.Mm.inp.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hom.Mm.inp_dbconn())
}

