datacache <- new.env(hash=TRUE, parent=emptyenv())

hguqiagenv3 <- function() showQCData("hguqiagenv3", datacache)
hguqiagenv3_dbconn <- function() dbconn(datacache)
hguqiagenv3_dbfile <- function() dbfile(datacache)
hguqiagenv3_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hguqiagenv3_dbInfo <- function() dbInfo(datacache)

hguqiagenv3ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hguqiagenv3.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hguqiagenv3", "chip hguqiagenv3", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hguqiagenv3.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hguqiagenv3_dbconn())
}

