datacache <- new.env(hash=TRUE, parent=emptyenv())

hguDKFZ31 <- function() showQCData("hguDKFZ31", datacache)
hguDKFZ31_dbconn <- function() dbconn(datacache)
hguDKFZ31_dbfile <- function() dbfile(datacache)
hguDKFZ31_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hguDKFZ31_dbInfo <- function() dbInfo(datacache)

hguDKFZ31ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hguDKFZ31.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hguDKFZ31", "chip hguDKFZ31", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hguDKFZ31.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hguDKFZ31_dbconn())
}

