datacache <- new.env(hash=TRUE, parent=emptyenv())

JazaeriMetaData <- function() showQCData("JazaeriMetaData", datacache)
JazaeriMetaData_dbconn <- function() dbconn(datacache)
JazaeriMetaData_dbfile <- function() dbfile(datacache)
JazaeriMetaData_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
JazaeriMetaData_dbInfo <- function() dbInfo(datacache)

JazaeriMetaDataORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "JazaeriMetaData.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "JazaeriMetaData", "chip JazaeriMetaData", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("JazaeriMetaData.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(JazaeriMetaData_dbconn())
}

