
\name{HuO22_dbconn}

\alias{HuO22_dbconn}
\alias{HuO22_dbfile}
\alias{HuO22_dbschema}
\alias{HuO22_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  HuO22_dbconn()
  HuO22_dbfile()
  HuO22_dbschema(file="", show.indices=FALSE)
  HuO22_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{HuO22_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{HuO22_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{HuO22_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{HuO22_dbschema} prints the schema definition of the
  package annotation DB.

  \code{HuO22_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{HuO22_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{HuO22_dbfile}: a character string with the path to the
  package annotation DB.

  \code{HuO22_dbschema}: none (invisible \code{NULL}).

  \code{HuO22_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(HuO22_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by HuO22_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=HuO22_dbfile(), cache_size=64000,
  synchronous=0)

  HuO22_dbschema()

  HuO22_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

