datacache <- new.env(hash=TRUE, parent=emptyenv())

HsAgilentDesign026652 <- function() showQCData("HsAgilentDesign026652", datacache)
HsAgilentDesign026652_dbconn <- function() dbconn(datacache)
HsAgilentDesign026652_dbfile <- function() dbfile(datacache)
HsAgilentDesign026652_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
HsAgilentDesign026652_dbInfo <- function() dbInfo(datacache)

HsAgilentDesign026652ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "HsAgilentDesign026652.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "HsAgilentDesign026652", "chip HsAgilentDesign026652", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("HsAgilentDesign026652.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(HsAgilentDesign026652_dbconn())
}

