### R code from vignette source 'specL.Rnw'

###################################################
### code chunk number 1: style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: specL.Rnw:73-74
###################################################
options(width = 80)


###################################################
### code chunk number 3: specL.Rnw:77-79
###################################################
library(specL)
data(peptideStd)


###################################################
### code chunk number 4: specL.Rnw:94-96
###################################################
demoIdx <- 40
str(peptideStd[[demoIdx]])


###################################################
### code chunk number 5: specL.Rnw:108-112
###################################################
res.peakplot <- peakplot(peptideSequence=peptideStd[[demoIdx]]$peptideSequence, 
               spec=peptideStd[[demoIdx]], 
               ion.axes=TRUE)



###################################################
### code chunk number 6: specL.Rnw:131-141
###################################################
 irtFASTAseq <- paste(">zz|ZZ_FGCZCont0260|",
"iRT_Protein_with_AAAAK_spacers concatenated Biognosys\n",
"LGGNEQVTRAAAAKGAGSSEPVTGLDAKAAAAKVEATFGVDESNAKAAAAKYILAGVENS",
"KAAAAKTPVISGGPYEYRAAAAKTPVITGAPYEYRAAAAKDGLDAASYYAPVRAAAAKAD",
"VTPADFSEWSKAAAAKGTFIIDPGGVIRAAAAKGTFIIDPAAVIRAAAAKLFLQFGAQGS",
"PFLK\n")

Tfile <- file();  cat(irtFASTAseq, file = Tfile);
fasta.irtFASTAseq <-read.fasta(Tfile, as.string=TRUE, seqtype="AA")
close(Tfile)


###################################################
### code chunk number 7: specL.Rnw:147-148
###################################################
peptideStd[[demoIdx]]$proteinInformation


###################################################
### code chunk number 8: specL.Rnw:152-154
###################################################
peptideStd <- annotateProteinID(peptideStd, 
    fasta=fasta.irtFASTAseq)


###################################################
### code chunk number 9: specL.Rnw:160-162
###################################################
(idx<-which(unlist(lapply(peptideStd, 
    function(x){nchar(x$proteinInformation)>0}))))


###################################################
### code chunk number 10: specL.Rnw:168-169
###################################################
peptideStd[[demoIdx]]$proteinInformation


###################################################
### code chunk number 11: specL.Rnw:174-175 (eval = FALSE)
###################################################
## digestPattern = "(([RK])|(^)|(^M))"


###################################################
### code chunk number 12: specL.Rnw:189-191
###################################################
res.genSwathIonLib <- genSwathIonLib(data=peptideStd, 
                                     data.fit=peptideStd.redundant)


###################################################
### code chunk number 13: specL.Rnw:197-198
###################################################
res.genSwathIonLib@ionlibrary[[demoIdx]]


###################################################
### code chunk number 14: specL.Rnw:202-203
###################################################
plot(res.genSwathIonLib@ionlibrary[[demoIdx]])


###################################################
### code chunk number 15: specL.Rnw:207-219
###################################################
# define customized fragment ions
# for demonstration lets consider only the top five singly charged y ions.

r.genSwathIonLib.top5 <- genSwathIonLib(peptideStd,
    peptideStd.redundant, topN=5,
    fragmentIonFUN=function (b, y) {
      return( cbind(y1_=y) )
      }
    )

plot(r.genSwathIonLib.top5@ionlibrary[[demoIdx]])



###################################################
### code chunk number 16: specL.Rnw:252-253 (eval = FALSE)
###################################################
## iRTpeptides


###################################################
### code chunk number 17: specL.Rnw:259-260 (eval = FALSE)
###################################################
## fit <- lm(formula = rt ~ aggregateInputRT * fileName, data=m)


###################################################
### code chunk number 18: specL.Rnw:267-269 (eval = FALSE)
###################################################
## data<-aggregate(df$rt, by=list(df$peptide, df$fileName), FUN=mean)
## data.fit<-aggregate(df.fit$rt, by=list(df.fit$peptide, df.fit$fileName), FUN=mean)


###################################################
### code chunk number 19: specL.Rnw:274-275 (eval = FALSE)
###################################################
## m <- merge(iRT, data.fit, by.x='peptide', by.y='peptide')


###################################################
### code chunk number 20: specL.Rnw:285-291
###################################################
# calls the plot method for a specLSet object
plot(res.genSwathIonLib)

# graph the iRT peptides of "zz|ZZ_FGCZCont0260|"
points(res.genSwathIonLib@rt.normalized[idx] ~ res.genSwathIonLib@rt.input[idx], 
       col='black', lwd=4, pch="x", cex=2)


###################################################
### code chunk number 21: specL.Rnw:303-304
###################################################
write.Spectronaut(res.genSwathIonLib, file="specL-Spectronaut.txt")


###################################################
### code chunk number 22: sessioninfo
###################################################
toLatex(sessionInfo())


