/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.transcription;

import java.util.EnumMap;
import java.util.Map;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.compound.RNACompoundSet;
import org.biojava3.core.sequence.io.IUPACParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;
import org.biojava3.core.sequence.io.RNASequenceCreator;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.transcription.DNAToRNATranslator;
import org.biojava3.core.sequence.transcription.Frame;
import org.biojava3.core.sequence.transcription.RNAToAminoAcidTranslator;
import org.biojava3.core.sequence.transcription.Table;

public class TranscriptionEngine {
    private final Table table;
    private final RNAToAminoAcidTranslator rnaAminoAcidTranslator;
    private final DNAToRNATranslator dnaRnaTranslator;
    private final SequenceCreatorInterface<AminoAcidCompound> proteinSequenceCreator;
    private final SequenceCreatorInterface<NucleotideCompound> rnaSequenceCreator;
    private final CompoundSet<NucleotideCompound> dnaCompounds;
    private final CompoundSet<NucleotideCompound> rnaCompounds;
    private final CompoundSet<AminoAcidCompound> aminoAcidCompounds;

    public static TranscriptionEngine getDefault() {
        return IOD.INSTANCE;
    }

    private TranscriptionEngine(Table table, RNAToAminoAcidTranslator rnaAminoAcidTranslator, DNAToRNATranslator dnaRnaTranslator, SequenceCreatorInterface<AminoAcidCompound> proteinSequenceCreator, SequenceCreatorInterface<NucleotideCompound> rnaSequenceCreator, CompoundSet<NucleotideCompound> dnaCompounds, CompoundSet<NucleotideCompound> rnaCompounds, CompoundSet<AminoAcidCompound> aminoAcidCompounds) {
        this.table = table;
        this.rnaAminoAcidTranslator = rnaAminoAcidTranslator;
        this.dnaRnaTranslator = dnaRnaTranslator;
        this.proteinSequenceCreator = proteinSequenceCreator;
        this.rnaSequenceCreator = rnaSequenceCreator;
        this.dnaCompounds = dnaCompounds;
        this.rnaCompounds = rnaCompounds;
        this.aminoAcidCompounds = aminoAcidCompounds;
    }

    public Sequence<AminoAcidCompound> translate(Sequence<NucleotideCompound> dna) {
        Map<Frame, Sequence<AminoAcidCompound>> trans = this.multipleFrameTranslation(dna, Frame.ONE);
        return trans.get((Object)Frame.ONE);
    }

    public Map<Frame, Sequence<AminoAcidCompound>> multipleFrameTranslation(Sequence<NucleotideCompound> dna, Frame ... frames) {
        EnumMap<Frame, Sequence<AminoAcidCompound>> results = new EnumMap<Frame, Sequence<AminoAcidCompound>>(Frame.class);
        for (Frame frame : frames) {
            Sequence<NucleotideCompound> rna = this.getDnaRnaTranslator().createSequence(dna, frame);
            Sequence peptide = this.getRnaAminoAcidTranslator().createSequence(rna);
            results.put(frame, peptide);
        }
        return results;
    }

    public Table getTable() {
        return this.table;
    }

    public RNAToAminoAcidTranslator getRnaAminoAcidTranslator() {
        return this.rnaAminoAcidTranslator;
    }

    public DNAToRNATranslator getDnaRnaTranslator() {
        return this.dnaRnaTranslator;
    }

    public SequenceCreatorInterface<AminoAcidCompound> getProteinSequenceCreator() {
        return this.proteinSequenceCreator;
    }

    public SequenceCreatorInterface<NucleotideCompound> getRnaSequenceCreator() {
        return this.rnaSequenceCreator;
    }

    public CompoundSet<NucleotideCompound> getDnaCompounds() {
        return this.dnaCompounds;
    }

    public CompoundSet<NucleotideCompound> getRnaCompounds() {
        return this.rnaCompounds;
    }

    public CompoundSet<AminoAcidCompound> getAminoAcidCompounds() {
        return this.aminoAcidCompounds;
    }

    public static class Builder {
        private Table table;
        private RNAToAminoAcidTranslator rnaAminoAcidTranslator;
        private DNAToRNATranslator dnaRnaTranslator;
        private SequenceCreatorInterface<AminoAcidCompound> proteinSequenceCreator;
        private SequenceCreatorInterface<NucleotideCompound> rnaSequenceCreator;
        private CompoundSet<NucleotideCompound> dnaCompounds;
        private CompoundSet<NucleotideCompound> rnaCompounds;
        private CompoundSet<AminoAcidCompound> aminoAcidCompounds;
        private boolean initMet = true;
        private boolean trimStop = true;
        private boolean translateNCodons = true;
        private boolean decorateRna = false;

        public TranscriptionEngine build() {
            return new TranscriptionEngine(this.getTable(), this.getRnaAminoAcidTranslator(), this.getDnaRnaTranslator(), this.getProteinCreator(), this.getRnaCreator(), this.getDnaCompounds(), this.getRnaCompounds(), this.getAminoAcidCompounds());
        }

        public Builder table(Integer id) {
            this.table = IUPACParser.getInstance().getTable(id);
            return this;
        }

        public Builder table(String name) {
            this.table = IUPACParser.getInstance().getTable(name);
            return this;
        }

        public Builder table(Table table) {
            this.table = table;
            return this;
        }

        public Builder dnaCompounds(CompoundSet<NucleotideCompound> compounds) {
            this.dnaCompounds = compounds;
            return this;
        }

        public Builder rnaCompounds(CompoundSet<NucleotideCompound> compounds) {
            this.rnaCompounds = compounds;
            return this;
        }

        public Builder aminoAcidsCompounds(CompoundSet<AminoAcidCompound> compounds) {
            this.aminoAcidCompounds = compounds;
            return this;
        }

        public Builder dnaRnaTranslator(DNAToRNATranslator translator) {
            this.dnaRnaTranslator = translator;
            return this;
        }

        public Builder rnaAminoAcidTranslator(RNAToAminoAcidTranslator translator) {
            this.rnaAminoAcidTranslator = translator;
            return this;
        }

        public Builder proteinCreator(SequenceCreatorInterface<AminoAcidCompound> creator) {
            this.proteinSequenceCreator = creator;
            return this;
        }

        public Builder rnaCreator(SequenceCreatorInterface<NucleotideCompound> creator) {
            this.rnaSequenceCreator = creator;
            return this;
        }

        public Builder initMet(boolean initMet) {
            this.initMet = initMet;
            return this;
        }

        public Builder trimStop(boolean trimStop) {
            this.trimStop = trimStop;
            return this;
        }

        public Builder translateNCodons(boolean translateNCodons) {
            this.translateNCodons = translateNCodons;
            return this;
        }

        public Builder decorateRna(boolean decorateRna) {
            this.decorateRna = decorateRna;
            return this;
        }

        private CompoundSet<NucleotideCompound> getDnaCompounds() {
            if (this.dnaCompounds != null) {
                return this.dnaCompounds;
            }
            return DNACompoundSet.getDNACompoundSet();
        }

        private CompoundSet<NucleotideCompound> getRnaCompounds() {
            if (this.rnaCompounds != null) {
                return this.rnaCompounds;
            }
            return RNACompoundSet.getRNACompoundSet();
        }

        private CompoundSet<AminoAcidCompound> getAminoAcidCompounds() {
            if (this.aminoAcidCompounds != null) {
                return this.aminoAcidCompounds;
            }
            return AminoAcidCompoundSet.getAminoAcidCompoundSet();
        }

        private DNAToRNATranslator getDnaRnaTranslator() {
            if (this.dnaRnaTranslator != null) {
                return this.dnaRnaTranslator;
            }
            return new DNAToRNATranslator(new RNASequenceCreator(this.getRnaCompounds()), this.getDnaCompounds(), this.getRnaCompounds(), this.isDecorateRna());
        }

        private RNAToAminoAcidTranslator getRnaAminoAcidTranslator() {
            if (this.rnaAminoAcidTranslator != null) {
                return this.rnaAminoAcidTranslator;
            }
            return new RNAToAminoAcidTranslator(this.getProteinCreator(), this.getRnaCompounds(), this.getCodons(), this.getAminoAcidCompounds(), this.getTable(), this.isTrimStop(), this.isInitMet(), this.isTranslateNCodons());
        }

        private CompoundSet<Table.Codon> getCodons() {
            return this.getTable().getCodonCompoundSet(this.getRnaCompounds(), this.getAminoAcidCompounds());
        }

        private SequenceCreatorInterface<AminoAcidCompound> getProteinCreator() {
            if (this.proteinSequenceCreator != null) {
                return this.proteinSequenceCreator;
            }
            return new ProteinSequenceCreator(this.getAminoAcidCompounds());
        }

        private SequenceCreatorInterface<NucleotideCompound> getRnaCreator() {
            if (this.rnaSequenceCreator != null) {
                return this.rnaSequenceCreator;
            }
            return new RNASequenceCreator(this.getRnaCompounds());
        }

        private Table getTable() {
            if (this.table != null) {
                return this.table;
            }
            this.table(1);
            return this.table;
        }

        private boolean isInitMet() {
            return this.initMet;
        }

        private boolean isTrimStop() {
            return this.trimStop;
        }

        private boolean isTranslateNCodons() {
            return this.translateNCodons;
        }

        private boolean isDecorateRna() {
            return this.decorateRna;
        }
    }

    private static final class IOD {
        public static final TranscriptionEngine INSTANCE = new Builder().build();

        private IOD() {
        }
    }
}

