## ----vignetteSetup, echo = FALSE, message = FALSE, warning = FALSE-------
## Track time spent on making the vignette
startTimeVignette <- Sys.time()

## Bib setup
library('knitcitations')

## Load knitcitations with a clean bibliography
cleanbib()
cite_options(hyperlink = 'to.doc', citation_format = 'text', style = 'html')
# Note links won't show for now due to the following issue
# https://github.com/cboettig/knitcitations/issues/63

## Write bibliography information
write.bibtex(c(knitcitations = citation('knitcitations'), 
    derfinder = citation('derfinder')[1], 
    regionReport = citation('regionReport')[1],
    knitrBootstrap = citation('knitrBootstrap'),
    ggbio = citation('ggbio'),
    ggplot2 = citation('ggplot2'),
    knitr = citation('knitr')[3],
    rmarkdown = citation('rmarkdown')),
    file = 'derfinderPlotRef.bib')
bib <- read.bibtex('derfinderPlotRef.bib')

## Assign short names
names(bib) <- c('knitcitations', 'derfinder', 'regionReport', 'knitrBootstrap',
    'ggbio', 'ggplot2', 'knitr', 'rmarkdown')

## ----createVignette, eval=FALSE, bootstrap.show.code=TRUE----------------
#  ## Create the vignette
#  library('knitrBootstrap')
#  
#  knitrBootstrapFlag <- packageVersion('knitrBootstrap') < '1.0.0'
#  if(knitrBootstrapFlag) {
#      ## CRAN version
#      system.time(knit_bootstrap('regionReport.Rmd', chooser=c('boot', 'code'), show_code = TRUE))
#      unlink('regionReport.md')
#  } else {
#      ## GitHub version
#      library('rmarkdown')
#      system.time(render('regionReport.Rmd',
#          'knitrBootstrap::bootstrap_document'))
#  }
#  ## Note: if you prefer the knitr version use:
#  # library('rmarkdown')
#  # system.time(render('regionReport.Rmd', 'html_document'))
#  
#  ## Extract the R code
#  library('knitr')
#  knit('regionReport.Rmd', tangle = TRUE)
#  
#  ## Copy report output to be distributed with the package for comparison
#  ## purposes
#  file.copy(file.path('report', 'html', 'basicExploration.html'),
#      '../inst/basicExploration/basicExploration.html', overwrite=TRUE)
#  
#  ## Clean up
#  file.remove('derfinderPlotRef.bib')
#  #unlink('regionReport_files', recursive=TRUE)
#  unlink('report', recursive = TRUE)

## ----vignetteReproducibility1, echo=FALSE--------------------------------
## Date the report was generated
Sys.time()

## ----vignetteReproducibility2, echo=FALSE, bootstrap.show.code=FALSE-----
## Processing time in seconds
totalTimeVignette <- diff(c(startTimeVignette, Sys.time()))
round(totalTimeVignette, digits=3)

## ----vignetteReproducibility3, echo=FALSE--------------------------------
## Session info
library('devtools')
session_info()

## ----vignetteBiblio, results='asis', echo=FALSE--------------------------
## Print bibliography
bibliography()

