## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"---------------------------------
    BiocStyle::latex()

## ----lib-load, message=FALSE------------------------------------------------------------
library(quantro)

## ----data-load, message=FALSE-----------------------------------------------------------

library(quantro)
library(minfi)
data(flowSorted)
p <- getBeta(flowSorted, offset = 100)
pd <- pData(flowSorted)
dim(p)
head(pd)

## ----plot-distributions-density, fig.height=5, fig.width=6------------------------------
matdensity(p, groupFactor = pd$CellType, col = c(2,3), xlab = " ", 
           ylab = "density", main = "Beta Values")
legend('top', c("NeuN_neg", "NeuN_pos"), col = c(2,3), lty= 1, lwd = 3)

## ----plot-distributions-boxplot, fig.height=5, fig.width=6------------------------------
matboxplot(p, groupFactor = pd$CellType, col = c(2,3), xaxt = "n", 
           main = "Beta Values")

## ----calculate-quantro1-----------------------------------------------------------------
qtest <- quantro(object = p, groupFactor = pd$CellType)
qtest

## ----quantro-summary--------------------------------------------------------------------
summary(qtest)

## ----quantro-medians--------------------------------------------------------------------
anova(qtest)

## ----quantro-quantroStat----------------------------------------------------------------
quantroStat(qtest)

## ----flowSorted-fullEx------------------------------------------------------------------
is(flowSorted, "MethylSet")
qtest <- quantro(flowSorted, groupFactor = pData(flowSorted)$CellType)
qtest 

## ----quantro-parallel-------------------------------------------------------------------
library(doParallel)
registerDoParallel(cores=4)
qtestPerm <- quantro(p, groupFactor = pd$CellType, B = 1000)
qtestPerm

## ----quantro-plot, fig.height=5, fig.width=6--------------------------------------------
quantroPlot(qtestPerm)

## ----sessionInfo,results ='markup'------------------------------------------------------
sessionInfo()

