/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.PsmPool;
import cn.bgi.Spectra;
import cn.bgi.TableHeader;
import cn.bgi.ValueComparator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;

public class FDRcalculator {
    private static boolean isScoreLowBetter = true;
    private static double confidentFilter = 0.01;
    private static String outFileName;

    public static void initialize(boolean isScoreLowBetter, double qvalueFilter, String outFileName) {
        FDRcalculator.isScoreLowBetter = isScoreLowBetter;
        confidentFilter = qvalueFilter;
        FDRcalculator.outFileName = outFileName;
    }

    public static void main(String[] args) throws Exception {
        String pepfile = "E:\\work\\java\\workspace\\tandemparser\\test\\testtte-peptideSummary.txt";
        FDRcalculator.fdrCalc(pepfile);
    }

    public static int[] fdrCalc(String pepfile) throws IOException {
        double d;
        BufferedReader bReader = new BufferedReader(new FileReader(new File(pepfile)));
        String headString = bReader.readLine().trim();
        String[] header = headString.split(TableHeader.pepSummaryFileDelimiter);
        HashMap<String, Integer> header2indexHashMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < header.length) {
            header2indexHashMap.put(header[i], i);
            ++i;
        }
        Spectra.setOutHead(headString);
        String line = null;
        PsmPool psmPool = new PsmPool();
        while ((line = bReader.readLine()) != null) {
            line = line.trim();
            String[] item = line.split(TableHeader.pepSummaryFileDelimiter);
            String spectraIndex = item[(Integer)header2indexHashMap.get(TableHeader.SpectraIndex)];
            int charString = Integer.valueOf(item[(Integer)header2indexHashMap.get(TableHeader.charge)]);
            Spectra psm = new Spectra(spectraIndex);
            psm.setCharge(charString);
            psm.setPepSeq(item[(Integer)header2indexHashMap.get(TableHeader.peptideSeq)]);
            psm.setDecoy(Integer.valueOf(item[(Integer)header2indexHashMap.get(TableHeader.decoyPrefix)]) == 1);
            psm.setOutLine(line);
            double d2 = Double.valueOf(item[(Integer)header2indexHashMap.get(TableHeader.evalue)]);
            psm.setScore(d2);
            psmPool.addPsm(psm);
            psmPool.putCharge2lastPSM(psm.getChargeClass(), psm);
        }
        bReader.close();
        ValueComparator bvc = new ValueComparator(psmPool.getPsm());
        TreeMap<Object, Spectra> sorted_map = new TreeMap<Object, Spectra>(bvc);
        sorted_map.putAll(psmPool.getPsm());
        System.out.println(sorted_map.size());
        HashMap charge2score2fdr = new HashMap();
        HashMap charge2score2qvalue = new HashMap();
        for (String string : psmPool.getCharge2lastPSM().keySet()) {
            psmPool.getCharge2lastPSM().put(string, psmPool.getPsm().get(sorted_map.firstKey()));
            charge2score2fdr.put(string, new HashMap());
        }
        for (String string : sorted_map.keySet()) {
            double fdr;
            Spectra psm = psmPool.getPsm().get(string);
            d = psm.getScore();
            String chargeClass = psm.getChargeClass();
            Spectra lastPSM = psmPool.getCharge2lastPSM().get(chargeClass);
            double lastScore = lastPSM.getScore();
            if (!psmPool.getCharge2decoyPsMap().containsKey(chargeClass)) {
                psmPool.getCharge2decoyPsMap().put(chargeClass, 0);
            }
            if (!psmPool.getCharge2targetPsMap().containsKey(chargeClass)) {
                psmPool.getCharge2targetPsMap().put(chargeClass, 0);
            }
            if (d > lastScore && isScoreLowBetter) {
                fdr = 0.0;
                if (psmPool.getTargetHitNum(chargeClass) > 0) {
                    fdr = 1.0 * (double)psmPool.getDecoyHitNum(chargeClass) / (double)psmPool.getTargetHitNum(chargeClass);
                }
                ((HashMap)charge2score2fdr.get(chargeClass)).put(lastScore, fdr);
            } else if (d < lastScore && !isScoreLowBetter) {
                fdr = 0.0;
                if (psmPool.getTargetHitNum(chargeClass) > 0) {
                    fdr = 1.0 * (double)psmPool.getDecoyHitNum(chargeClass) / (double)psmPool.getTargetHitNum(chargeClass);
                }
                ((HashMap)charge2score2fdr.get(chargeClass)).put(lastScore, fdr);
            }
            psmPool.getCharge2lastPSM().put(chargeClass, psm);
            psmPool.addPsm2chargeMap(psm);
        }
        for (String string : psmPool.getCharge2lastPSM().keySet()) {
            Spectra lastPSM = psmPool.getCharge2lastPSM().get(string);
            d = lastPSM.getScore();
            double fdr = 0.0;
            if (psmPool.getTargetHitNum(string) > 0) {
                fdr = 1.0 * (double)psmPool.getDecoyHitNum(string) / (double)psmPool.getTargetHitNum(string);
            }
            ((HashMap)charge2score2fdr.get(string)).put(d, fdr);
        }
        for (String string : charge2score2fdr.keySet()) {
            HashMap score2fdr = (HashMap)charge2score2fdr.get(string);
            Object[] objectArray = score2fdr.keySet().toArray();
            Arrays.sort(objectArray);
            Double minFDR = (Double)score2fdr.get((Double)objectArray[objectArray.length - 1]);
            charge2score2qvalue.put(string, new HashMap());
            int i2 = objectArray.length - 1;
            while (i2 >= 0) {
                double score = (Double)objectArray[i2];
                double fdr = (Double)score2fdr.get(score);
                double qvalue = -1.0;
                if (fdr > minFDR) {
                    qvalue = minFDR;
                } else {
                    qvalue = fdr;
                    minFDR = fdr;
                }
                ((HashMap)charge2score2qvalue.get(string)).put(score, qvalue);
                --i2;
            }
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(outFileName)));
        bufferedWriter.write(String.valueOf(Spectra.getOutHead()) + "\n");
        int sumIdentPSMs = 0;
        HashSet<String> uniquePeptideSeqSet = new HashSet<String>();
        for (String string : sorted_map.keySet()) {
            Spectra psm = psmPool.getPsm().get(string);
            psm.setFDR((Double)((HashMap)charge2score2fdr.get(psm.getChargeClass())).get(psm.getScore()));
            psm.setQvalue((Double)((HashMap)charge2score2qvalue.get(psm.getChargeClass())).get(psm.getScore()));
            if (psm.isDecoy() || !(psm.getQvalue() <= confidentFilter)) continue;
            bufferedWriter.write(String.valueOf(psm.getOutLine()) + "\n");
            ++sumIdentPSMs;
            uniquePeptideSeqSet.add(psm.getPepSeq());
        }
        bufferedWriter.close();
        int[] nArray = new int[]{sumIdentPSMs, uniquePeptideSeqSet.size()};
        return nArray;
    }
}

