### R code from vignette source 'prebs.Rnw'

###################################################
### code chunk number 1: prebs.Rnw:38-40 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("prebs")


###################################################
### code chunk number 2: prebs.Rnw:45-47 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("prebsdata")


###################################################
### code chunk number 3: prebs.Rnw:57-58
###################################################
library(prebs)


###################################################
### code chunk number 4: prebs.Rnw:65-76
###################################################
bam_file1 <- system.file(file.path("sample_bam_files", "input1.bam"), 
                         package="prebsdata")
bam_file2 <- system.file(file.path("sample_bam_files", "input2.bam"), 
                         package="prebsdata")
bam_files <- c(bam_file1, bam_file2)
custom_cdf_mapping1 <- system.file(file.path("custom-cdf", 
    "HGU133Plus2_Hs_ENSG_mapping.txt"), package="prebsdata")
custom_cdf_mapping2 <- system.file(file.path("custom-cdf", 
    "HGU133A2_Hs_ENSG_mapping.txt"), package="prebsdata")
manufacturer_cdf_mapping <- system.file(file.path("manufacturer-cdf", 
    "HGU133Plus2_mapping.txt"), package="prebsdata")


###################################################
### code chunk number 5: prebs.Rnw:143-148 (eval = FALSE)
###################################################
## library("parallel")
## N_CORES = 2
## CLUSTER <- makeCluster(N_CORES)
## prebs_values <- calc_prebs(bam_files, custom_cdf_mapping1, cluster=CLUSTER)
## stopCluster(CLUSTER)


###################################################
### code chunk number 6: prebs.Rnw:154-155 (eval = FALSE)
###################################################
## prebs_values <- calc_prebs(bam_files, custom_cdf_mapping2)


###################################################
### code chunk number 7: prebs.Rnw:164-166
###################################################
prebs_values <- calc_prebs(bam_files, manufacturer_cdf_mapping)
head(exprs(prebs_values))


###################################################
### code chunk number 8: prebs.Rnw:175-177 (eval = FALSE)
###################################################
## prebs_values <- calc_prebs(bam_files, manufacturer_cdf_mapping, 
##                            cdf_name="hgu133plus2cdf")


###################################################
### code chunk number 9: prebs.Rnw:226-228 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("hgu133plus2cdf")


###################################################
### code chunk number 10: prebs.Rnw:236-238 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("hgu133plus2probe")


###################################################
### code chunk number 11: prebs.Rnw:241-244
###################################################
library("hgu133plus2probe")
probes <- as.data.frame(hgu133plus2probe)
head(probes)


###################################################
### code chunk number 12: prebs.Rnw:249-253 (eval = FALSE)
###################################################
## library("affy")
## probes <- probes[substr(probes$Probe.Set.Name,1,4) != "AFFX",]
## probes$Probe.ID <- xy2indices(probes$x, probes$y, cdf="hgu133plus2cdf")
## write.table(probes, file="probes.txt", quote=FALSE, row.names=FALSE, col.names=TRUE)


###################################################
### code chunk number 13: prebs.Rnw:271-289 (eval = FALSE)
###################################################
## probe_mappings <- read.table("output_probe_mappings.map")
## 
## colnames(probe_mappings) <- c("Probe.ID", "strand", 
##                               "chr", "start", "seq", "match", "multiple")
## 
## # bowtie reports 0-offset, but _mapping.txt files are 1-offset
## probe_mappings$start <- probe_mappings$start + 1 
## 
## probes <- read.table("probes.txt", head=TRUE)
## 
## probes <- merge(probes, probe_mappings)
## 
## output_table <- data.frame(Probe.Set.Name=probes$Probe.Set.Name, 
##     Chr=probes$chr, Chr.Strand=probes$strand, Chr.From=probes$start, 
##     Probe.X=probes$x, Probe.Y=probes$y, Affy.Probe.Set.Name=probes$Probe.Set.Name)
## 
## write.table(output_table, file="HGU133Plus2_mapping.txt", 
##             quote=FALSE, sep="\t", row.names=FALSE)


###################################################
### code chunk number 14: sessionInfo
###################################################
sessionInfo()


