/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.fd.FDLayoutEdge;
import org.ivis.layout.fd.FDLayoutNode;
import org.ivis.layout.sbgn.Compaction;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.SbgnProcessNode;
import org.ivis.layout.util.MemberPack;
import org.ivis.layout.util.RectProc;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public class SbgnPDLayout
extends CoSELayout {
    Map<SbgnPDNode, LGraph> childGraphMap;
    Map<SbgnPDNode, MemberPack> memberPackMap;
    LinkedList<SbgnPDNode> dummyComplexList;
    Map<SbgnPDNode, LGraph> removedDummyComplexMap;
    LinkedList<SbgnPDNode> complexOrder;
    private DefaultCompactionAlgorithm compactionMethod = DefaultCompactionAlgorithm.TILING;
    public double properlyOrientedEdgeCount;
    public double totalEdgeCount;
    private int phaseNumber;
    public int phase1IterationCount;
    public int phase2IterationCount;

    public SbgnPDLayout() {
        this.childGraphMap = new HashMap<SbgnPDNode, LGraph>();
        this.complexOrder = new LinkedList();
        this.dummyComplexList = new LinkedList();
        this.removedDummyComplexMap = new HashMap<SbgnPDNode, LGraph>();
        if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            this.memberPackMap = new HashMap<SbgnPDNode, MemberPack>();
        }
    }

    @Override
    public void runSpringEmbedder() {
        this.phaseNumber = 1;
        this.doPhase1();
        this.phaseNumber = 2;
        this.doPhase2();
        this.removeDummyCompounds();
    }

    private void doPhase1() {
        this.maxIterations = 200;
        this.totalIterations = 0;
        do {
            ++this.totalIterations;
            if (this.totalIterations % 100 == 0) {
                if (this.isConverged()) break;
                this.coolingFactor = this.initialCoolingFactor * ((double)(this.maxIterations - this.totalIterations) / (double)this.maxIterations);
            }
            this.totalDisplacement = 0.0;
            this.graphManager.updateBounds();
            this.calcSpringForces();
            this.calcRepulsionForces();
            this.calcGravitationalForces();
            this.moveNodes();
            this.animate();
        } while (this.totalIterations < this.maxIterations);
        this.graphManager.updateBounds();
        this.phase1IterationCount = this.totalIterations;
        System.out.print("" + this.phase1IterationCount + " ");
    }

    private void doPhase2() {
        double newRatio = 0.0;
        double oldRatio = 0.0;
        this.maxIterations = (int)Math.log(this.getAllEdges().length + this.getAllNodes().length) * 400;
        this.coolingFactor = this.initialCoolingFactor = 0.3;
        this.totalIterations = 0;
        do {
            ++this.totalIterations;
            if (this.totalIterations == 1 || this.totalIterations % 211 == 0 && this.totalIterations < 3 * this.maxIterations / 4) {
                this.approximateSingleNodesPositions();
            }
            if (this.totalIterations % 100 == 0) {
                oldRatio = newRatio;
                newRatio = this.properlyOrientedEdgeCount / this.totalEdgeCount;
                if (this.isConverged() && newRatio > 1.0) break;
                this.coolingFactor = this.initialCoolingFactor * ((double)(this.maxIterations - this.totalIterations) / (double)this.maxIterations);
            }
            this.totalDisplacement = 0.0;
            this.graphManager.updateBounds();
            this.calcSpringForces();
            this.calcRepulsionForces();
            this.calcGravitationalForces();
            this.moveNodes();
            this.animate();
        } while (this.totalIterations < this.maxIterations && this.maxIterations < 10000);
        System.out.println(this.properlyOrientedEdgeCount + " " + this.totalEdgeCount + " " + this.totalIterations + " " + newRatio);
        this.phase2IterationCount = this.totalIterations;
        this.graphManager.updateBounds();
        System.out.println("phase2 has finished after " + this.phase2IterationCount + " iterations");
    }

    private void approximateSingleNodesPositions() {
        for (Object o : this.getAllNodes()) {
            if (!(o instanceof SbgnProcessNode)) continue;
            SbgnProcessNode processNode = (SbgnProcessNode)o;
            this.applyApproximation(processNode.getInputPort());
            this.applyApproximation(processNode.getOutputPort());
            this.applyEffectorApproximation(processNode);
        }
    }

    private void applyEffectorApproximation(SbgnProcessNode process2) {
        LinkedList<SbgnPDNode> effectorNodes = new LinkedList<SbgnPDNode>();
        PointD newPoint = new PointD();
        PointD approximationPnt = new PointD();
        for (Object o : process2.getEdges()) {
            SbgnPDEdge edge = (SbgnPDEdge)o;
            if (!edge.type.equals("catalysis")) continue;
            effectorNodes.add((SbgnPDNode)edge.getSource());
        }
        for (SbgnPDNode eff : effectorNodes) {
            if (eff.getEdges().size() != 1) continue;
            if (process2.isHorizontal()) {
                approximationPnt.x = process2.getCenterX();
                approximationPnt.y = eff.getCenterY() > process2.getCenterY() ? process2.getCenterY() + this.idealEdgeLength : process2.getCenterY() - this.idealEdgeLength;
            } else if (process2.isVertical()) {
                approximationPnt.y = process2.getCenterY();
                approximationPnt.x = eff.getCenterX() > process2.getCenterX() ? process2.getCenterX() + this.idealEdgeLength : process2.getCenterX() - this.idealEdgeLength;
            }
            newPoint.x = approximationPnt.x + Math.random() * 50.0 * 2.0 - 50.0;
            newPoint.y = approximationPnt.y + Math.random() * 50.0 * 2.0 - 50.0;
            eff.setCenter(newPoint.x, newPoint.y);
        }
    }

    private void applyApproximation(SbgnPDNode port) {
        LinkedList<SbgnPDNode> oneEdgeNodes = new LinkedList<SbgnPDNode>();
        LinkedList<SbgnPDNode> multiEdgeNodes = new LinkedList<SbgnPDNode>();
        SbgnPDNode nodeOfInterest = null;
        for (Object e2 : port.getEdges()) {
            SbgnPDEdge edge = (SbgnPDEdge)e2;
            if (edge.type.equals("rigid edge")) continue;
            if (port.type.equals("input_port")) {
                nodeOfInterest = (SbgnPDNode)edge.getSource();
            } else if (port.type.equals("output_port")) {
                nodeOfInterest = (SbgnPDNode)edge.getTarget();
            }
            if (nodeOfInterest.getEdges().size() == 1) {
                oneEdgeNodes.add(nodeOfInterest);
                continue;
            }
            if (nodeOfInterest.getEdges().size() <= 1) continue;
            multiEdgeNodes.add(nodeOfInterest);
        }
        if (oneEdgeNodes.size() > 0) {
            this.moveOneEdgeNodes(oneEdgeNodes, multiEdgeNodes);
        }
    }

    private void moveOneEdgeNodes(LinkedList<SbgnPDNode> oneEdgeNodes, LinkedList<SbgnPDNode> multiEdgeNodes) {
        PointD approximationPnt = new PointD(0.0, 0.0);
        int randomIndex = -1;
        SbgnPDNode approximationNode = null;
        if (multiEdgeNodes.size() > 0) {
            approximationNode = multiEdgeNodes.get(0);
            for (SbgnPDNode node : multiEdgeNodes) {
                if (node.getEdges().size() <= approximationNode.getEdges().size()) continue;
                approximationNode = node;
            }
            approximationPnt.x = approximationNode.getCenterX();
            approximationPnt.y = approximationNode.getCenterY();
        } else if (multiEdgeNodes.size() == 0) {
            randomIndex = (int)(Math.random() * (double)oneEdgeNodes.size());
            approximationNode = oneEdgeNodes.get(randomIndex);
            approximationPnt.x = approximationNode.getCenterX();
            approximationPnt.y = approximationNode.getCenterY();
        }
        for (SbgnPDNode s : oneEdgeNodes) {
            if (approximationNode.getOwner() != s.getOwner()) continue;
            PointD newPoint = new PointD();
            newPoint.x = approximationPnt.x + Math.random() * 50.0 * 2.0 - 50.0;
            newPoint.y = approximationPnt.y + Math.random() * 50.0 * 2.0 - 50.0;
            s.setCenter(newPoint.x, newPoint.y);
        }
    }

    private void removeDummyCompounds() {
        for (Object o : this.getAllNodes()) {
            SbgnPDNode node = (SbgnPDNode)o;
            if (!node.isDummyCompound) continue;
            LGraph childGraph = node.getChild();
            LGraph owner = node.getOwner();
            for (Object s : childGraph.getNodes()) {
                owner.add((SbgnPDNode)s);
            }
            for (Object e2 : childGraph.getEdges()) {
                SbgnPDEdge edge = (SbgnPDEdge)e2;
                owner.add(edge, edge.getSource(), edge.getTarget());
            }
            this.getGraphManager().getGraphs().remove(childGraph);
            node.setChild(null);
            owner.remove(node);
        }
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    private void applyDFSOnComplexes() {
        for (Object o : this.getAllNodes()) {
            if (!(o instanceof SbgnPDNode) || !((SbgnPDNode)o).isComplex()) continue;
            SbgnPDNode comp = (SbgnPDNode)o;
            if (comp.visited) continue;
            this.DFSVisitComplex(comp);
        }
        for (SbgnPDNode o : this.complexOrder) {
            this.clearComplex(o);
        }
        this.getGraphManager().updateBounds();
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
    }

    private void DFSVisitComplex(SbgnPDNode node) {
        if (node.getChild() != null) {
            for (Object n : node.getChild().getNodes()) {
                SbgnPDNode sbgnChild = (SbgnPDNode)n;
                this.DFSVisitComplex(sbgnChild);
            }
        }
        if (node.isComplex() && !node.containsUnmarkedComplex()) {
            this.complexOrder.add(node);
            node.visited = true;
            return;
        }
    }

    private void groupZeroDegreeMembers() {
        HashMap<SbgnPDNode, LGraph> childComplexMap = new HashMap<SbgnPDNode, LGraph>();
        for (Object graphObj : this.getGraphManager().getGraphs()) {
            ArrayList<SbgnPDNode> zeroDegreeNodes = new ArrayList<SbgnPDNode>();
            LGraph ownerGraph = (LGraph)graphObj;
            if (ownerGraph.getParent().type != null && ((SbgnPDNode)ownerGraph.getParent()).isComplex()) continue;
            for (Object nodeObj : ownerGraph.getNodes()) {
                SbgnPDNode node = (SbgnPDNode)nodeObj;
                if (this.calcGraphDegree(node) != 0) continue;
                zeroDegreeNodes.add(node);
            }
            if (zeroDegreeNodes.size() <= 1) continue;
            SbgnPDNode complex2 = (SbgnPDNode)this.newNode(null);
            complex2.type = "complex";
            complex2.label = "DummyComplex_" + ownerGraph.getParent().label;
            ownerGraph.add(complex2);
            LGraph childGraph = this.newGraph(null);
            for (SbgnPDNode zeroNode : zeroDegreeNodes) {
                ownerGraph.remove(zeroNode);
                childGraph.add(zeroNode);
            }
            this.dummyComplexList.add(complex2);
            childComplexMap.put(complex2, childGraph);
        }
        for (SbgnPDNode complex3 : this.dummyComplexList) {
            this.graphManager.add((LGraph)childComplexMap.get(complex3), complex3);
        }
        this.getGraphManager().updateBounds();
        this.graphManager.resetAllNodes();
        this.graphManager.resetAllNodesToApplyGravitation();
        this.graphManager.resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    private int calcGraphDegree(SbgnPDNode parentNode) {
        int degree = 0;
        if (parentNode.getChild() == null) {
            degree = parentNode.getEdges().size();
            return degree;
        }
        for (Object o : parentNode.getChild().getNodes()) {
            degree = degree + parentNode.getEdges().size() + this.calcGraphDegree((SbgnPDNode)o);
        }
        return degree;
    }

    private void clearComplex(SbgnPDNode comp) {
        MemberPack pack = null;
        LGraph childGr = comp.getChild();
        this.childGraphMap.put(comp, childGr);
        if (childGr == null) {
            return;
        }
        if (this.compactionMethod == DefaultCompactionAlgorithm.POLYOMINO_PACKING) {
            this.applyPolyomino(comp);
        } else if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            pack = new MemberPack(childGr);
            this.memberPackMap.put(comp, pack);
        }
        if (this.dummyComplexList.contains(comp)) {
            for (Object o : comp.getChild().getNodes()) {
                this.removeDummyComplexGraphs((SbgnPDNode)o);
            }
        }
        this.getGraphManager().getGraphs().remove(childGr);
        comp.setChild(null);
        if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            comp.setWidth(pack.getWidth());
            comp.setHeight(pack.getHeight());
        }
        if (childGr != null) {
            for (Object ch : childGr.getNodes()) {
                SbgnPDNode chNd = (SbgnPDNode)ch;
                for (Object obj : new ArrayList(chNd.getEdges())) {
                    LEdge edge = (LEdge)obj;
                    if (edge.getSource() == chNd) {
                        chNd.getEdges().remove(edge);
                        edge.setSource(comp);
                        comp.getEdges().add(edge);
                        continue;
                    }
                    if (edge.getTarget() != chNd) continue;
                    chNd.getEdges().remove(edge);
                    edge.setTarget(comp);
                    comp.getEdges().add(edge);
                }
            }
        }
    }

    private void removeDummyComplexGraphs(SbgnPDNode comp) {
        if (comp.getChild() == null || comp.isDummyCompound) {
            return;
        }
        for (Object o : comp.getChild().getNodes()) {
            SbgnPDNode childNode = (SbgnPDNode)o;
            if (childNode.getChild() == null || childNode.getEdges().size() != 0) continue;
            this.removeDummyComplexGraphs(childNode);
        }
        if (this.graphManager.getGraphs().contains(comp.getChild()) && this.calcGraphDegree(comp) == 0) {
            this.removedDummyComplexMap.put(comp, comp.getChild());
            this.getGraphManager().getGraphs().remove(comp.getChild());
            comp.setChild(null);
        }
    }

    private void applyPolyomino(SbgnPDNode parent) {
        LGraph childGr = parent.getChild();
        if (childGr == null) {
            System.out.println("Child graph is empty (Polyomino)");
        } else {
            SbgnPDNode[] mpArray = new SbgnPDNode[childGr.getNodes().size()];
            for (int i = 0; i < childGr.getNodes().size(); ++i) {
                SbgnPDNode s;
                mpArray[i] = s = (SbgnPDNode)childGr.getNodes().get(i);
            }
            RectProc.packRectanglesMino(5.0, mpArray.length, mpArray);
            Compaction c = new Compaction((ArrayList)childGr.getNodes());
            c.perform();
            RectangleD r = this.calculateBounds(true, (ArrayList)childGr.getNodes());
            parent.setWidth(r.getWidth());
            parent.setHeight(r.getHeight());
        }
    }

    protected void repopulateComplexes() {
        LGraph chGr;
        for (SbgnPDNode comp : this.removedDummyComplexMap.keySet()) {
            chGr = this.removedDummyComplexMap.get(comp);
            comp.setChild(chGr);
            this.getGraphManager().getGraphs().add(chGr);
        }
        for (int i = this.complexOrder.size() - 1; i >= 0; --i) {
            SbgnPDNode comp;
            comp = this.complexOrder.get(i);
            chGr = this.childGraphMap.get(comp);
            comp.setChild(chGr);
            if (chGr == null) continue;
            if (this.compactionMethod == DefaultCompactionAlgorithm.POLYOMINO_PACKING) {
                this.adjustLocation(comp, chGr);
                this.getGraphManager().getGraphs().add(chGr);
                continue;
            }
            if (this.compactionMethod != DefaultCompactionAlgorithm.TILING) continue;
            this.getGraphManager().getGraphs().add(chGr);
            MemberPack pack = this.memberPackMap.get(comp);
            pack.adjustLocations(comp.getLeft(), comp.getTop());
        }
        for (SbgnPDNode comp : this.removedDummyComplexMap.keySet()) {
            chGr = this.removedDummyComplexMap.get(comp);
            this.adjustLocation(comp, chGr);
        }
        this.removeDummyComplexes();
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    private void adjustLocation(SbgnPDNode comp, LGraph chGr) {
        RectangleD rect = this.calculateBounds(false, (ArrayList)chGr.getNodes());
        int differenceX = (int)(rect.x - comp.getLeft());
        int differenceY = (int)(rect.y - comp.getTop());
        if (!comp.type.equals("complex")) {
            differenceX -= 5;
            differenceY -= 5;
        }
        for (int j = 0; j < chGr.getNodes().size(); ++j) {
            SbgnPDNode s = (SbgnPDNode)chGr.getNodes().get(j);
            s.setLocation(s.getLeft() - (double)differenceX + 5.0, s.getTop() - (double)differenceY + 5.0);
            if (s.getChild() == null) continue;
            this.adjustLocation(s, s.getChild());
        }
    }

    private void removeDummyComplexes() {
        for (SbgnPDNode dummyComplex : this.dummyComplexList) {
            LGraph childGraph = dummyComplex.getChild();
            LGraph owner = dummyComplex.getOwner();
            this.getGraphManager().getGraphs().remove(childGraph);
            dummyComplex.setChild(null);
            owner.remove(dummyComplex);
            for (Object s : childGraph.getNodes()) {
                owner.add((SbgnPDNode)s);
            }
        }
    }

    protected RectangleD calculateBounds(boolean isMarginIncluded, ArrayList<SbgnPDNode> nodes) {
        int boundLeft = Integer.MAX_VALUE;
        int boundRight = Integer.MIN_VALUE;
        int boundTop = Integer.MAX_VALUE;
        int boundBottom = Integer.MIN_VALUE;
        for (LNode lNode : nodes) {
            int nodeLeft = (int)lNode.getLeft();
            int nodeRight = (int)lNode.getRight();
            int nodeTop = (int)lNode.getTop();
            int nodeBottom = (int)lNode.getBottom();
            if (boundLeft > nodeLeft) {
                boundLeft = nodeLeft;
            }
            if (boundRight < nodeRight) {
                boundRight = nodeRight;
            }
            if (boundTop > nodeTop) {
                boundTop = nodeTop;
            }
            if (boundBottom >= nodeBottom) continue;
            boundBottom = nodeBottom;
        }
        if (isMarginIncluded) {
            return new RectangleD(boundLeft - 20, boundTop - 20, boundRight - boundLeft + 40, boundBottom - boundTop + 40);
        }
        return new RectangleD(boundLeft, boundTop, boundRight - boundLeft, boundBottom - boundTop);
    }

    protected void calculateFullnessOfComplexes() {
        LNode largestComplex = null;
        double totalArea = 0.0;
        double usedArea = 0.0;
        double maxArea = Double.MIN_VALUE;
        for (int i = 0; i < this.getAllNodes().length; ++i) {
            SbgnPDNode s = (SbgnPDNode)this.getAllNodes()[i];
            if (!s.type.equals("complex") || !(s.getWidth() * s.getHeight() > maxArea)) continue;
            maxArea = s.getWidth() * s.getHeight();
            largestComplex = s;
        }
        usedArea = this.calculateUsedArea((SbgnPDNode)largestComplex);
        totalArea = largestComplex.getWidth() * largestComplex.getHeight();
        if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            System.out.println("Tiling results");
        } else if (this.compactionMethod == DefaultCompactionAlgorithm.POLYOMINO_PACKING) {
            System.out.println("Polyomino Packing results");
        }
        System.out.println(" = " + usedArea / totalArea);
    }

    protected double calculateUsedArea(SbgnPDNode parent) {
        int totalArea = 0;
        if (parent.getChild() == null) {
            return 0.0;
        }
        for (int i = 0; i < parent.getChild().getNodes().size(); ++i) {
            SbgnPDNode node = (SbgnPDNode)parent.getChild().getNodes().get(i);
            totalArea = !node.type.equalsIgnoreCase("complex") ? (int)((double)totalArea + node.getWidth() * node.getHeight()) : (int)((double)totalArea + this.calculateUsedArea(node));
        }
        return totalArea;
    }

    @Override
    public LNode newNode(Object vNode) {
        return new SbgnPDNode(this.graphManager, vNode);
    }

    @Override
    public LEdge newEdge(Object vEdge) {
        return new SbgnPDEdge(null, null, vEdge);
    }

    @Override
    public boolean layout() {
        boolean b = false;
        this.groupZeroDegreeMembers();
        this.applyDFSOnComplexes();
        b = super.layout();
        this.repopulateComplexes();
        this.getAllNodes();
        return b;
    }

    @Override
    protected boolean classicLayout() {
        this.calculateNodesToApplyGravitationTo();
        this.graphManager.calcLowestCommonAncestors();
        this.graphManager.calcInclusionTreeDepths();
        this.graphManager.getRoot().calcEstimatedSize();
        this.calcIdealEdgeLengths();
        if (!this.incremental) {
            ArrayList<ArrayList<LNode>> forest = this.getFlatForest();
            if (forest.size() > 0) {
                this.positionNodesRadially(forest);
            } else {
                this.positionNodesRandomly();
            }
        }
        if (!this.arePortNodesCreated()) {
            this.createPortNodes();
            this.graphManager.resetAllNodes();
            this.graphManager.resetAllNodesToApplyGravitation();
            this.graphManager.resetAllEdges();
            this.calculateNodesToApplyGravitationTo();
        }
        this.initSpringEmbedder();
        this.runSpringEmbedder();
        return true;
    }

    private void createPortNodes() {
        for (Object o : this.getAllNodes()) {
            SbgnPDNode originalProcessNode = (SbgnPDNode)o;
            if (!originalProcessNode.type.equals("process")) continue;
            LGraph ownerGraph = originalProcessNode.getOwner();
            SbgnProcessNode processNode = (SbgnProcessNode)this.newProcessNode(null);
            SbgnPDNode inputPort = (SbgnPDNode)this.newPortNode(null, "input_port");
            SbgnPDNode outputPort = (SbgnPDNode)this.newPortNode(null, "output_port");
            SbgnPDNode compoundNode = (SbgnPDNode)this.newNode(null);
            compoundNode.type = "dummy compound";
            compoundNode.label = "DummyCompound_" + originalProcessNode.label;
            inputPort.label = "InputPort_" + originalProcessNode.label;
            outputPort.label = "OutputPort_" + originalProcessNode.label;
            LGraph childGraph = this.newGraph(null);
            ownerGraph.add(processNode);
            processNode.copyFromSBGNPDNode(originalProcessNode, this.getGraphManager());
            processNode.setConnectedNodes(compoundNode, inputPort, outputPort);
            this.connectEdges(inputPort, outputPort, processNode);
            SbgnPDEdge rigidToProduction = (SbgnPDEdge)this.newRigidEdge(null);
            rigidToProduction.label = "" + (this.graphManager.getAllEdges().length + 1);
            SbgnPDEdge rigidToConsumption = (SbgnPDEdge)this.newRigidEdge(null);
            rigidToConsumption.label = "" + (this.graphManager.getAllEdges().length + 2);
            ownerGraph.remove(processNode);
            childGraph.add(processNode);
            childGraph.add(inputPort);
            childGraph.add(outputPort);
            childGraph.add(rigidToProduction, inputPort, processNode);
            childGraph.add(rigidToConsumption, outputPort, processNode);
            compoundNode.setOwner(ownerGraph);
            compoundNode.setCenter(processNode.getCenterX(), processNode.getCenterY());
            ownerGraph.add(compoundNode);
            this.graphManager.add(childGraph, compoundNode);
            ownerGraph.remove(originalProcessNode);
            this.graphManager.updateBounds();
        }
        this.graphManager.resetAllNodes();
        this.graphManager.resetAllNodesToApplyGravitation();
        this.graphManager.resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    public void connectEdges(SbgnPDNode inputPort, SbgnPDNode outputPort, SbgnProcessNode processNode) {
        for (int i = 0; i < processNode.getEdges().size(); ++i) {
            SbgnPDEdge sEdge = (SbgnPDEdge)processNode.getEdges().get(i);
            processNode.getEdges().remove(sEdge);
            if (sEdge.type.equals("consumption")) {
                sEdge.setTarget(inputPort);
                inputPort.getEdges().add(sEdge);
            } else if (sEdge.type.equals("production")) {
                sEdge.setSource(outputPort);
                outputPort.getEdges().add(sEdge);
            }
            --i;
        }
    }

    private boolean arePortNodesCreated() {
        boolean flag = false;
        for (Object o : this.getAllNodes()) {
            SbgnPDNode s = (SbgnPDNode)o;
            if (!s.type.equals("process")) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return true;
        }
        for (Object o : this.getAllNodes()) {
            if (!((SbgnPDNode)o).type.equals("input_port") && !((SbgnPDNode)o).type.equals("output_port")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calcSpringForces() {
        Object[] lEdges = this.getAllEdges();
        for (int i = 0; i < lEdges.length; ++i) {
            FDLayoutEdge edge = (FDLayoutEdge)lEdges[i];
            if (edge.type.equals("rigid edge")) continue;
            this.calcSpringForce(edge, edge.idealLength);
        }
    }

    @Override
    public void calcRepulsionForces() {
        Object[] lNodes = this.getAllNodes();
        if (this.useFRGridVariant) {
            FDLayoutNode nodeA;
            int i;
            if (this.totalIterations % 10 == 1) {
                this.grid = this.calcGrid(this.graphManager.getRoot());
                for (i = 0; i < lNodes.length; ++i) {
                    nodeA = (FDLayoutNode)lNodes[i];
                    this.addNodeToGrid(nodeA, this.grid, this.graphManager.getRoot().getLeft(), this.graphManager.getRoot().getTop());
                }
            }
            HashSet<FDLayoutNode> processedNodeSet = new HashSet<FDLayoutNode>();
            for (i = 0; i < lNodes.length; ++i) {
                nodeA = (FDLayoutNode)lNodes[i];
                this.calculateRepulsionForceOfANode(this.grid, nodeA, processedNodeSet);
                processedNodeSet.add(nodeA);
            }
        } else {
            for (int i = 0; i < lNodes.length; ++i) {
                FDLayoutNode nodeA = (FDLayoutNode)lNodes[i];
                for (int j = i + 1; j < lNodes.length; ++j) {
                    FDLayoutNode nodeB = (FDLayoutNode)lNodes[j];
                    if (nodeA.getOwner() != nodeB.getOwner() || nodeA.type != null && nodeB.type != null && nodeA.getOwner().equals(nodeB.getOwner()) && (nodeA.type.equals("input_port") || nodeA.type.equals("output_port") || nodeB.type.equals("input_port") || nodeB.type.equals("output_port"))) continue;
                    this.calcRepulsionForce(nodeA, nodeB);
                }
            }
        }
    }

    @Override
    protected void calculateRepulsionForceOfANode(Vector[][] grid, FDLayoutNode nodeA, HashSet<FDLayoutNode> processedNodeSet) {
        int i;
        if (this.totalIterations % 10 == 1) {
            HashSet<FDLayoutNode> surrounding = new HashSet<FDLayoutNode>();
            for (i = nodeA.startX - 1; i < nodeA.finishX + 2; ++i) {
                for (int j = nodeA.startY - 1; j < nodeA.finishY + 2; ++j) {
                    if (i < 0 || j < 0 || i >= grid.length || j >= grid[0].length) continue;
                    for (Object obj : grid[i][j]) {
                        FDLayoutNode nodeB = (FDLayoutNode)obj;
                        if (nodeA.getOwner() != nodeB.getOwner() || nodeA == nodeB || nodeA.type != null && nodeB.type != null && nodeA.getOwner().equals(nodeB.getOwner()) && (nodeA.type.equals("input_port") || nodeA.type.equals("output_port") || nodeB.type.equals("input_port") || nodeB.type.equals("output_port")) || processedNodeSet.contains(nodeB) || surrounding.contains(nodeB)) continue;
                        double distanceX = Math.abs(nodeA.getCenterX() - nodeB.getCenterX()) - (nodeA.getWidth() / 2.0 + nodeB.getWidth() / 2.0);
                        double distanceY = Math.abs(nodeA.getCenterY() - nodeB.getCenterY()) - (nodeA.getHeight() / 2.0 + nodeB.getHeight() / 2.0);
                        if (!(distanceX <= this.repulsionRange) || !(distanceY <= this.repulsionRange)) continue;
                        surrounding.add(nodeB);
                    }
                }
            }
            nodeA.surrounding = surrounding.toArray();
        }
        for (i = 0; i < nodeA.surrounding.length; ++i) {
            this.calcRepulsionForce(nodeA, (FDLayoutNode)nodeA.surrounding[i]);
        }
    }

    @Override
    public void moveNodes() {
        ArrayList<SbgnProcessNode> processNodesToBeRotated = new ArrayList<SbgnProcessNode>();
        this.properlyOrientedEdgeCount = 0.0;
        this.totalEdgeCount = 0.0;
        for (Object o : this.getAllNodes()) {
            if (!(o instanceof SbgnProcessNode)) continue;
            SbgnProcessNode p = (SbgnProcessNode)o;
            SbgnPDNode c = p.parentCompound;
            SbgnPDNode d1 = p.getInputPort();
            SbgnPDNode d2 = p.getOutputPort();
            this.properlyOrientedEdgeCount += p.calculateRotationalForces(this.idealEdgeLength);
            this.totalEdgeCount += (double)(p.inputNeighborNodeList.size() + p.outputNeighborNodeList.size());
            p.transferForces();
            p.resetForces();
            d1.resetForces();
            d2.resetForces();
        }
        if (this.totalIterations % 2 == 0 && this.phaseNumber == 2) {
            boolean rotationAvailability = false;
            for (Object o : this.getAllNodes()) {
                if (!(o instanceof SbgnProcessNode) || !(rotationAvailability = ((SbgnProcessNode)o).checkRotationAvailability())) continue;
                processNodesToBeRotated.add((SbgnProcessNode)o);
            }
            if (processNodesToBeRotated.size() > 0) {
                int randomNumber = (int)(Math.random() * (double)processNodesToBeRotated.size());
                SbgnProcessNode p = (SbgnProcessNode)processNodesToBeRotated.get(randomNumber);
                p.applyRotation();
            }
        }
        super.moveNodes();
    }

    public LNode newPortNode(Object vNode, String type) {
        SbgnPDNode n = new SbgnPDNode(this.graphManager, vNode);
        n.type = type;
        n.setWidth(3.0);
        n.setHeight(3.0);
        return n;
    }

    public LNode newProcessNode(Object vNode) {
        return new SbgnProcessNode(this.graphManager, vNode);
    }

    public LEdge newRigidEdge(Object vEdge) {
        SbgnPDEdge e2 = new SbgnPDEdge(null, null, vEdge);
        e2.type = "rigid edge";
        return e2;
    }

    public static enum DefaultCompactionAlgorithm {
        TILING,
        POLYOMINO_PACKING;

    }
}

